/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean.copier;

import com.sondertara.common.bean.copier.BeanCopier;
import com.sondertara.common.bean.copier.BeanCopierRegistry;
import com.sondertara.common.bean.copier.ConverterRegistry;
import com.sondertara.common.bean.exception.BeanAnalysisException;
import com.sondertara.common.convert.TypeConverter;
import java.lang.reflect.Type;

class Utils {
    Utils() {
    }

    static boolean isBuiltin(Class<?> cls) {
        return cls.isPrimitive() || cls.getName().startsWith("java.") || cls.getName().startsWith("javax.");
    }

    static String nameOf(Type type) {
        String str = type.toString();
        int idxOfSpace = str.lastIndexOf(32);
        if (idxOfSpace >= 0) {
            return str.substring(idxOfSpace + 1);
        }
        return str;
    }

    static TypeConverter<?> findOrCreateConverter(String fromType, String toType) {
        Class<?> toCls;
        Class<?> fromCls;
        try {
            fromCls = Class.forName(fromType);
            toCls = Class.forName(toType);
        }
        catch (ClassNotFoundException e) {
            throw new BeanAnalysisException(e);
        }
        TypeConverter<Object> converter = ConverterRegistry.find(fromType, toType);
        if (converter == null && !toCls.isAssignableFrom(fromCls)) {
            if (!Utils.isBuiltin(fromCls) && !Utils.isBuiltin(toCls)) {
                BeanCopier beanCopier = BeanCopierRegistry.prepare(fromCls, toCls);
                converter = beanCopier::copyConvert;
            }
            if (converter == null) {
                throw new BeanAnalysisException(String.format("Converter not found. from: %s, to: %s", fromType, toType));
            }
        }
        return converter;
    }
}

