/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sondertara.common.cache.ILocalCache;
import com.sondertara.common.exception.TaraException;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuavaAbstractLoadingCache<K, V>
implements ILocalCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaAbstractLoadingCache.class);
    private int maximumSize = 1000;
    private int expireAfterWriteDuration = 60;
    private final TimeUnit timeUnit = TimeUnit.SECONDS;
    private Date resetTime;
    private volatile long highestSize = 0L;
    private Date highestTime;
    private volatile LoadingCache<K, Optional<V>> cache;
    private final AtomicBoolean reload = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadingCache<K, Optional<V>> getCache() {
        if (this.reload.get()) {
            this.cache = null;
        }
        if (this.cache == null) {
            GuavaAbstractLoadingCache guavaAbstractLoadingCache = this;
            synchronized (guavaAbstractLoadingCache) {
                if (this.cache == null) {
                    this.cache = CacheBuilder.newBuilder().maximumSize((long)this.maximumSize).expireAfterWrite((long)this.expireAfterWriteDuration, this.timeUnit).recordStats().build(new CacheLoader<K, Optional<V>>(){

                        public Optional<V> load(K key) {
                            return GuavaAbstractLoadingCache.this.fetchData(key);
                        }
                    });
                    this.resetTime = new Date();
                    this.highestTime = new Date();
                    this.reload.set(false);
                    log.info("\u672c\u5730\u7f13\u5b58{}\u521d\u59cb\u5316\u6210\u529f,\u8fc7\u671f\u65f6\u95f4{}s", (Object)this, (Object)this.expireAfterWriteDuration);
                }
            }
        }
        return this.cache;
    }

    public void put(K key, V value) {
        this.getCache().put(key, Optional.ofNullable(value));
    }

    protected abstract Optional<V> fetchData(K var1);

    protected Optional<V> getValue(K key) throws TaraException {
        try {
            if (null == key) {
                return Optional.empty();
            }
            Optional optional = (Optional)this.getCache().get(key);
            if (this.getCache().size() > this.highestSize) {
                this.highestSize = this.getCache().size();
                this.highestTime = new Date();
            }
            if (log.isDebugEnabled()) {
                log.debug("Get cache success,key=[{}]", key);
            }
            return optional;
        }
        catch (Exception e) {
            if (e instanceof UncheckedExecutionException && e.getCause() != null && e.getCause() instanceof TaraException) {
                log.error("key={} get cache failed", key, (Object)e.getCause());
                throw (TaraException)e.getCause();
            }
            log.error("key={} get cache failed,{}", key, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Optional<V> get(K key) {
        return this.getValue(key);
    }

    public void invalidateAll() {
        this.getCache().invalidateAll();
    }

    public void invalidate(K key) {
        this.getCache().invalidate(key);
    }

    public long getHighestSize() {
        return this.highestSize;
    }

    public Date getHighestTime() {
        return this.highestTime;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public int getExpireAfterWriteDuration() {
        return this.expireAfterWriteDuration;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setExpireAfterWriteDuration(int expireAfterWriteDuration) {
        this.expireAfterWriteDuration = expireAfterWriteDuration;
        this.reload();
    }

    public void reload() {
        this.getCache().cleanUp();
        this.reload.set(true);
    }
}

