/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.convert;

import com.sondertara.common.convert.TypeConverter;
import com.sondertara.common.convert.impl.AtomicIntegerTypeConverter;
import com.sondertara.common.convert.impl.AtomicLongTypeConverter;
import com.sondertara.common.convert.impl.BigDecimalTypeConverter;
import com.sondertara.common.convert.impl.BigIntegerTypeConverter;
import com.sondertara.common.convert.impl.DateTypeConverter;
import com.sondertara.common.convert.impl.NumberTypeConverter;
import com.sondertara.common.convert.impl.StringTypeConverter;
import com.sondertara.common.convert.impl.primitive.BooleanPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.BytePrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.CharPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.DoublePrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.FloatPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.IntegerPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.LongPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.primitive.ShortPrimitiveTypeConverter;
import com.sondertara.common.convert.impl.wrapper.BooleanWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.ByteWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.DoubleWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.FloatWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.IntegerWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.LongWrapperTypeConverter;
import com.sondertara.common.convert.impl.wrapper.ShortWrapperTypeConverter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConvertUtils {
    private static final Map<Type, TypeConverter<?>> DEFAULT_TYPE_CONVERTER_MAP = new HashMap();

    private ConvertUtils() {
    }

    public static <T> T convert(Class<T> type, Object value) {
        return ConvertUtils.convert(type, value);
    }

    public static <T> T convert(Type type, Object value) {
        return ConvertUtils.getConverter(type).convert(value, null);
    }

    private static <T> TypeConverter<T> getConverter(Type type) {
        TypeConverter<?> typeConverter = DEFAULT_TYPE_CONVERTER_MAP.get(type);
        if (typeConverter != null) {
            return typeConverter;
        }
        throw new UnsupportedOperationException("No Converter for type [" + type.getTypeName() + "]");
    }

    static {
        DEFAULT_TYPE_CONVERTER_MAP.put(Integer.TYPE, new IntegerPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Long.TYPE, new LongPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Byte.TYPE, new BytePrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Short.TYPE, new ShortPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Float.TYPE, new FloatPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Double.TYPE, new DoublePrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Character.TYPE, new CharPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put(Boolean.TYPE, new BooleanPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Integer.class), new IntegerWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Long.class), new LongWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Byte.class), new ByteWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Short.class), new ShortWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Float.class), new FloatWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Double.class), new DoubleWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Boolean.class), new BooleanWrapperTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Character.class), new CharPrimitiveTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Date.class), new DateTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)String.class), new StringTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)AtomicInteger.class), new AtomicIntegerTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)AtomicLong.class), new AtomicLongTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)BigDecimal.class), new BigDecimalTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)BigInteger.class), new BigIntegerTypeConverter());
        DEFAULT_TYPE_CONVERTER_MAP.put((Type)((Object)Number.class), new NumberTypeConverter());
    }
}

