/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.util.HexUtils;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    static final String AES = "AES";
    static final String SHA1_PRNG = "SHA1PRNG";

    public static byte[] initKey(String key, int keySize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            SecureRandom random = SecureRandom.getInstance(SHA1_PRNG);
            random.setSeed(key.getBytes());
            keyGenerator.init(keySize, random);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaraException("Init secretKey error", e);
        }
    }

    public static String encrypt(String plainText, String key, int keySize) {
        if (plainText == null || plainText.length() < 1) {
            return null;
        }
        try {
            byte[] enCodeFormat = AESUtils.initKey(key, keySize);
            SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, AES);
            Cipher cipher = Cipher.getInstance(AES);
            byte[] byteContent = plainText.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, secretKeySpec);
            byte[] bytes = cipher.doFinal(byteContent);
            StringBuffer sb = new StringBuffer();
            for (byte aByte : bytes) {
                StringBuilder hex = new StringBuilder(Integer.toHexString(aByte & 0xFF));
                if (hex.length() == 1) {
                    hex.insert(0, '0');
                }
                sb.append(hex.toString().toUpperCase());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new TaraException("AES encrypt error", e);
        }
    }

    public static String decrypt(String cipherText, String key, int keySize) {
        if (cipherText == null || cipherText.length() < 1) {
            return null;
        }
        if (cipherText.trim().length() < 19) {
            return cipherText;
        }
        byte[] bytesResult = HexUtils.decodeHex(cipherText);
        try {
            byte[] bytes = AESUtils.initKey(key, keySize);
            SecretKeySpec secretKeySpec = new SecretKeySpec(bytes, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, secretKeySpec);
            byte[] result = cipher.doFinal(bytesResult);
            return new String(result);
        }
        catch (Exception e) {
            throw new TaraException("AES decrypt error", e);
        }
    }

    public static void main(String[] args) {
        try {
            String cipherText = AESUtils.encrypt("\u4e00\u7247\u6625\u6101\u5f85\u9152\u6d47\uff0c\u6c5f\u4e0a\u821f\u6447\uff0c\u697c\u4e0a\u5e18\u62db\u3002\u79cb\u5a18\u6e21\u4e0e\u6cf0\u5a18\u6865\uff0c\u98ce\u53c8\u98d8\u98d8\uff0c\u96e8\u53c8\u8427\u8427\u3002", "666888", 256);
            System.out.println("\u5bc6\u6587: " + cipherText);
            String clearText = AESUtils.decrypt(cipherText, "666888", 256);
            System.out.println("\u660e\u6587\uff1a" + clearText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

