/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto.asymmetric;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.util.HexUtils;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class DHUtils {
    private static final String KEY_DH = "DH";
    public static final String DH_PUBLIC_KEY = "DHPublicKey";
    public static final String DH_PRIVATE_KEY = "DHPrivateKey";
    public static final String KEY_DH_AES = "AES";

    public static Map<String, Key> initKey(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_DH);
            keyPairGenerator.initialize(keySize < 512 ? 1024 : keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            HashMap<String, Key> keyMap = new HashMap<String, Key>(2);
            keyMap.put(DH_PUBLIC_KEY, keyPair.getPublic());
            keyMap.put(DH_PRIVATE_KEY, keyPair.getPrivate());
            return keyMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Key> initKey(byte[] publicKey) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_DH);
            DHPublicKey dhPublicKey = (DHPublicKey)keyFactory.generatePublic(x509KeySpec);
            DHParameterSpec dhParameterSpec = dhPublicKey.getParams();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_DH);
            keyPairGenerator.initialize(dhParameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            HashMap<String, Key> keyMap = new HashMap<String, Key>(2);
            keyMap.put(DH_PUBLIC_KEY, keyPair.getPublic());
            keyMap.put(DH_PRIVATE_KEY, keyPair.getPrivate());
            return keyMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getSecretKeyBytes(byte[] publicKey, byte[] privateKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_DH);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(privateKey);
            PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(KEY_DH);
            keyAgreement.init(priKey);
            keyAgreement.doPhase(pubKey, true);
            return keyAgreement.generateSecret(KEY_DH_AES).getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey getSecretKey(byte[] publicKey, byte[] privateKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_DH);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(privateKey);
            PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(KEY_DH);
            keyAgreement.init(priKey);
            keyAgreement.doPhase(pubKey, true);
            return keyAgreement.generateSecret(KEY_DH_AES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getPublicKey(Map<String, Key> keyMap) {
        Key key = keyMap.get(DH_PUBLIC_KEY);
        return key.getEncoded();
    }

    public static byte[] getPrivateKey(Map<String, Key> keyMap) {
        Key key = keyMap.get(DH_PRIVATE_KEY);
        return key.getEncoded();
    }

    public static byte[] encrypt(byte[] data, byte[] publicKey, byte[] privateKey) {
        try {
            SecretKey secretKey = DHUtils.getSecretKey(publicKey, privateKey);
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("DH encrypt error", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] publicKey, byte[] privateKey) {
        try {
            SecretKey secretKey = DHUtils.getSecretKey(publicKey, privateKey);
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("DH encrypt error", e);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("jdk.crypto.KeyAgreement.legacyKDF", "true");
        Map<String, Key> keyMap1 = DHUtils.initKey(1024);
        byte[] publicKey1 = DHUtils.getPublicKey(keyMap1);
        byte[] privateKey1 = DHUtils.getPrivateKey(keyMap1);
        System.out.println("\u7532\u65b9\u516c\u94a5 : " + HexUtils.encodeHexStr(publicKey1));
        System.out.println("\u7532\u65b9\u79c1\u94a5 : " + HexUtils.encodeHexStr(privateKey1));
        Map<String, Key> keyMap2 = DHUtils.initKey(publicKey1);
        byte[] publicKey2 = DHUtils.getPublicKey(keyMap2);
        byte[] privateKey2 = DHUtils.getPrivateKey(keyMap2);
        System.out.println("\u4e59\u65b9\u516c\u94a5 : " + HexUtils.encodeHexStr(publicKey2));
        System.out.println("\u4e59\u65b9\u79c1\u94a5 : " + HexUtils.encodeHexStr(privateKey2));
        byte[] secretKey1 = DHUtils.getSecretKeyBytes(publicKey2, privateKey1);
        System.out.println("\u7532\u65b9\u672c\u5730\u5bc6\u94a5 : " + HexUtils.encodeHexStr(secretKey1));
        byte[] secretKey2 = DHUtils.getSecretKeyBytes(publicKey1, privateKey2);
        System.out.println("\u4e59\u65b9\u672c\u5730\u5bc6\u94a5 : " + HexUtils.encodeHexStr(secretKey2));
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        System.out.println("\u52a0\u5bc6\u524d\u7684\u6570\u636e\uff1a" + srcStr);
        byte[] encrypt = DHUtils.encrypt(srcStr.getBytes(), publicKey2, privateKey1);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e \u5b57\u8282\u6570\u7ec4\u8f6c16\u8fdb\u5236\uff1a" + HexUtils.encodeHexStr(encrypt));
        byte[] decrypt = DHUtils.decrypt(encrypt, publicKey1, privateKey2);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u6570\u636e\uff1a" + new String(decrypt));
    }
}

