/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto.asymmetric;

import com.sondertara.common.exception.TaraException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class DSAUtils {
    public static final String ALGORITHM = "DSA";

    public static KeyPair initKey() {
        return DSAUtils.initKey(1024);
    }

    public static KeyPair initKey(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGen.initialize(keySize);
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
    }

    public static byte[] sign(byte[] data, byte[] privateKey, String signatureAlgorithm) throws Exception {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initSign(priKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] sign, String signatureAlgorithm) throws Exception {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initVerify(pubKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void main(String[] args) throws Exception {
        String str = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        System.out.println("\u660e\u6587\uff1a" + str);
        KeyPair keyPair = DSAUtils.initKey();
        byte[] keyPairPrivate = keyPair.getPrivate().getEncoded();
        byte[] keyPairPublic = keyPair.getPublic().getEncoded();
        System.out.println("\u79c1\u94a5\uff1a" + Base64.getEncoder().encodeToString(keyPairPrivate));
        System.out.println("\u516c\u94a5\uff1a" + Base64.getEncoder().encodeToString(keyPairPublic));
        for (DsaSignatureAlgorithm algorithm : DsaSignatureAlgorithm.values()) {
            System.out.println("-----------------------------------------");
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\uff1a" + algorithm.getName());
            byte[] signed = DSAUtils.sign(str.getBytes(), keyPairPrivate, algorithm.getName());
            System.out.println("\u7b7e\u540d\uff1a" + Base64.getEncoder().encodeToString(signed));
            boolean verify = DSAUtils.verify(str.getBytes(), keyPairPublic, signed, algorithm.getName());
            System.out.println("\u9a8c\u7b7e\uff1a" + verify);
        }
    }

    public static enum DsaSignatureAlgorithm {
        SHA1withDSA,
        SHA224withDSA,
        SHA256withDSA;


        public String getName() {
            return this.name();
        }
    }
}

