/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto.asymmetric;

import com.sondertara.common.exception.TaraException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static final String RSA = "RSA";
    public static final String ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final byte[] DEFAULT_SPLIT = "#PART#".getBytes();
    public static final int DEFAULT_BUFFER_SIZE = 245;

    public static KeyPair initKey(int keyLength) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(RSA);
            SecureRandom secureRandom = new SecureRandom();
            kpg.initialize(keyLength, secureRandom);
            return kpg.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaraException("RSA init key pair error", e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] publicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory kf = KeyFactory.getInstance(RSA);
            PublicKey keyPublic = kf.generatePublic(keySpec);
            Cipher cp = Cipher.getInstance(ECB_PKCS1_PADDING);
            cp.init(1, keyPublic);
            return cp.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("RSA encryptByPublicKey error", e);
        }
    }

    public static String encryptByPublicKey(String plainText, String publicKeyBase64) {
        byte[] bytes = RSAUtils.encryptByPublicKey(plainText.getBytes(StandardCharsets.UTF_8), Base64.decodeBase64((String)publicKeyBase64));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory kf = KeyFactory.getInstance(RSA);
            PrivateKey keyPrivate = kf.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(ECB_PKCS1_PADDING);
            cipher.init(1, keyPrivate);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("RSA encryptByPublicKey error", e);
        }
    }

    public static String encryptByPrivateKey(String plainText, String privateKeyBase64) {
        byte[] bytes = RSAUtils.encryptByPrivateKey(plainText.getBytes(StandardCharsets.UTF_8), Base64.decodeBase64((String)privateKeyBase64));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] publicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory kf = KeyFactory.getInstance(RSA);
            PublicKey keyPublic = kf.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(ECB_PKCS1_PADDING);
            cipher.init(2, keyPublic);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("RSA encryptByPublicKey error", e);
        }
    }

    public static String decryptByPublicKey(String cipherBase64, String publicKeyBase64) {
        byte[] bytes = RSAUtils.decryptByPublicKey(Base64.decodeBase64((String)cipherBase64), Base64.decodeBase64((String)publicKeyBase64));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] decryptByPrivateKey(byte[] encrypted, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory kf = KeyFactory.getInstance(RSA);
            PrivateKey keyPrivate = kf.generatePrivate(keySpec);
            Cipher cp = Cipher.getInstance(ECB_PKCS1_PADDING);
            cp.init(2, keyPrivate);
            return cp.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new TaraException("RSA encryptByPublicKey error", e);
        }
    }

    public static String decryptByPrivateKey(String cipherBase64, String privateKeyBase64) {
        byte[] bytes = RSAUtils.decryptByPrivateKey(Base64.decodeBase64((String)cipherBase64), Base64.decodeBase64((String)privateKeyBase64));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] encryptByPublicKeyForSpilt(byte[] data, byte[] publicKey) {
        int dataLen = data.length;
        if (dataLen <= 245) {
            return RSAUtils.encryptByPublicKey(data, publicKey);
        }
        ArrayList<Byte> allBytes = new ArrayList<Byte>(2048);
        int bufIndex = 0;
        int subDataLoop = 0;
        Object buf = new byte[245];
        for (int i = 0; i < dataLen; ++i) {
            assert (buf != null);
            buf[bufIndex] = data[i];
            if (++bufIndex != 245 && i != dataLen - 1) continue;
            if (++subDataLoop != 1) {
                for (byte b : DEFAULT_SPLIT) {
                    allBytes.add(b);
                }
            }
            byte[] encryptBytes = RSAUtils.encryptByPublicKey(buf, publicKey);
            for (Object b : (Object)encryptBytes) {
                allBytes.add((byte)b);
            }
            bufIndex = 0;
            buf = i == dataLen - 1 ? null : new byte[Math.min(245, dataLen - i - 1)];
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static byte[] encryptByPrivateKeyForSpilt(byte[] data, byte[] privateKey) {
        int dataLen = data.length;
        if (dataLen <= 245) {
            return RSAUtils.encryptByPrivateKey(data, privateKey);
        }
        ArrayList<Byte> allBytes = new ArrayList<Byte>(2048);
        int bufIndex = 0;
        int subDataLoop = 0;
        Object buf = new byte[245];
        for (int i = 0; i < dataLen; ++i) {
            assert (buf != null);
            buf[bufIndex] = data[i];
            if (++bufIndex != 245 && i != dataLen - 1) continue;
            if (++subDataLoop != 1) {
                for (byte b : DEFAULT_SPLIT) {
                    allBytes.add(b);
                }
            }
            byte[] encryptBytes = RSAUtils.encryptByPrivateKey(buf, privateKey);
            for (Object b : (Object)encryptBytes) {
                allBytes.add((byte)b);
            }
            bufIndex = 0;
            buf = i == dataLen - 1 ? null : new byte[Math.min(245, dataLen - i - 1)];
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static byte[] decryptByPublicKeyForSpilt(byte[] encrypted, byte[] publicKey) throws Exception {
        int splitLen = DEFAULT_SPLIT.length;
        if (splitLen <= 0) {
            return RSAUtils.decryptByPublicKey(encrypted, publicKey);
        }
        int dataLen = encrypted.length;
        ArrayList<Byte> allBytes = new ArrayList<Byte>(1024);
        int latestStartIndex = 0;
        for (int i = 0; i < dataLen; ++i) {
            byte[] decryptPart;
            byte[] part;
            byte bt = encrypted[i];
            boolean isMatchSplit = false;
            if (i == dataLen - 1) {
                part = new byte[dataLen - latestStartIndex];
                System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
                for (byte b : decryptPart = RSAUtils.decryptByPublicKey(part, publicKey)) {
                    allBytes.add(b);
                }
                latestStartIndex = i + splitLen;
                i = latestStartIndex - 1;
            } else if (bt == DEFAULT_SPLIT[0]) {
                if (splitLen > 1) {
                    if (i + splitLen < dataLen) {
                        for (int j = 1; j < splitLen && DEFAULT_SPLIT[j] == encrypted[i + j]; ++j) {
                            if (j != splitLen - 1) continue;
                            isMatchSplit = true;
                            break;
                        }
                    }
                } else {
                    isMatchSplit = true;
                }
            }
            if (!isMatchSplit) continue;
            part = new byte[i - latestStartIndex];
            System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
            for (byte b : decryptPart = RSAUtils.decryptByPublicKey(part, publicKey)) {
                allBytes.add(b);
            }
            latestStartIndex = i + splitLen;
            i = latestStartIndex - 1;
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static byte[] decryptByPrivateKeyForSpilt(byte[] encrypted, byte[] privateKey) {
        int splitLen = DEFAULT_SPLIT.length;
        if (splitLen <= 0) {
            return RSAUtils.decryptByPrivateKey(encrypted, privateKey);
        }
        int dataLen = encrypted.length;
        ArrayList<Byte> allBytes = new ArrayList<Byte>(1024);
        int latestStartIndex = 0;
        for (int i = 0; i < dataLen; ++i) {
            byte[] decryptPart;
            byte[] part;
            byte bt = encrypted[i];
            boolean isMatchSplit = false;
            if (i == dataLen - 1) {
                part = new byte[dataLen - latestStartIndex];
                System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
                for (byte b : decryptPart = RSAUtils.decryptByPrivateKey(part, privateKey)) {
                    allBytes.add(b);
                }
                latestStartIndex = i + splitLen;
                i = latestStartIndex - 1;
            } else if (bt == DEFAULT_SPLIT[0]) {
                if (splitLen > 1) {
                    if (i + splitLen < dataLen) {
                        for (int j = 1; j < splitLen && DEFAULT_SPLIT[j] == encrypted[i + j]; ++j) {
                            if (j != splitLen - 1) continue;
                            isMatchSplit = true;
                            break;
                        }
                    }
                } else {
                    isMatchSplit = true;
                }
            }
            if (!isMatchSplit) continue;
            part = new byte[i - latestStartIndex];
            System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
            for (byte b : decryptPart = RSAUtils.decryptByPrivateKey(part, privateKey)) {
                allBytes.add(b);
            }
            latestStartIndex = i + splitLen;
            i = latestStartIndex - 1;
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static String keyEncrypt(Key key) {
        return new String(Base64.encodeBase64((byte[])key.getEncoded()));
    }

    public static void main(String[] args) throws Exception {
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        KeyPair keyPair = RSAUtils.initKey(4196);
        System.out.println("\u516c\u94a5\uff1a" + RSAUtils.keyEncrypt(keyPair.getPublic()));
        System.out.println("\u79c1\u94a5\uff1a" + RSAUtils.keyEncrypt(keyPair.getPrivate()));
        byte[] bytes = RSAUtils.encryptByPublicKey(srcStr.getBytes(StandardCharsets.UTF_8), keyPair.getPublic().getEncoded());
        System.out.println("\u539f\u59cb\u4fe1\u606f\uff1a" + srcStr + " \u52a0\u5bc6\u540e\u7684\u5bc6\u6587\u4e3a\uff1a");
        System.out.println(Base64.encodeBase64String((byte[])bytes));
        byte[] bytes1 = RSAUtils.decryptByPrivateKey(bytes, keyPair.getPrivate().getEncoded());
        System.out.println("\u5bc6\u6587\u89e3\u5bc6\u540e\u4e3a\uff1a" + new String(bytes1));
        String s = RSAUtils.encryptByPublicKey(srcStr, RSAUtils.keyEncrypt(keyPair.getPublic()));
        String s1 = RSAUtils.decryptByPrivateKey(s, RSAUtils.keyEncrypt(keyPair.getPrivate()));
        System.out.println(s1);
    }
}

