/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto.digest;

import com.sondertara.common.exception.TaraException;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public class MD5Utils {
    static final String MD5 = "MD5";

    public static String encrypt(String data) {
        byte[] dataBytes = data.getBytes();
        try {
            MessageDigest md5 = MessageDigest.getInstance(MD5);
            md5.update(dataBytes);
            byte[] resultBytes = md5.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : resultBytes) {
                if (Integer.toHexString(0xFF & b).length() == 1) {
                    sb.append("0").append(Integer.toHexString(0xFF & b));
                    continue;
                }
                sb.append(Integer.toHexString(0xFF & b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaraException("MD5 encrypt error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encryptFile(String filePath) {
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] resultBytes;
            StringBuilder sb = new StringBuilder();
            MappedByteBuffer byteBuffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance(MD5);
            md5.update(byteBuffer);
            for (byte b : resultBytes = md5.digest()) {
                if (Integer.toHexString(0xFF & b).length() == 1) {
                    sb.append("0").append(Integer.toHexString(0xFF & b));
                    continue;
                }
                sb.append(Integer.toHexString(0xFF & b));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new TaraException("MD5 encryptFile error", e);
        }
    }

    public static String encrypt(String value, String saltValue) {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            md.update(value.getBytes());
            md.update(saltValue.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.out.println("md5 " + value + "\u52a0\u5bc6\u5931\u8d25\uff01");
            return null;
        }
    }

    public static String repeatEncrypt(String data, int time) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        String result = MD5Utils.encrypt(data);
        for (int i = 0; i < time - 1; ++i) {
            result = MD5Utils.encrypt(result);
        }
        return MD5Utils.encrypt(result);
    }

    public static void main(String[] args) {
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        System.out.println("\u539f\u59cb\u4fe1\u606f\uff1a" + srcStr);
        System.out.println("MD5\u52a0\u5bc6\u540e(\u5bc6\u6587\u957f\u5ea632\u4f4d)\uff1a" + MD5Utils.encrypt(srcStr));
    }
}

