/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto.symmetric;

import com.sondertara.common.exception.TaraException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DESUtils {
    static final String DES = "DES";

    public static byte[] encrypt(byte[] plainBytes, String password) {
        try {
            password = DESUtils.formatPassword(password);
            SecureRandom secureRandom = new SecureRandom();
            DESKeySpec desKeySpec = new DESKeySpec(password.getBytes());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey securekey = secretKeyFactory.generateSecret(desKeySpec);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(1, (Key)securekey, secureRandom);
            return cipher.doFinal(plainBytes);
        }
        catch (Throwable e) {
            throw new TaraException("DES encrypt error.", e);
        }
    }

    public static byte[] decrypt(byte[] cipherBytes, String password) {
        try {
            password = DESUtils.formatPassword(password);
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(2, (Key)securekey, random);
            return cipher.doFinal(cipherBytes);
        }
        catch (Exception e) {
            throw new TaraException("DES decrypt error", e);
        }
    }

    public static String encrypt(String plainText, String password) {
        byte[] bytes = DESUtils.encrypt(plainText.getBytes(StandardCharsets.UTF_8), password);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decrypt(String base64Str, String password) {
        byte[] bytes = Base64.decodeBase64((String)base64Str);
        byte[] decrypt = DESUtils.decrypt(bytes, password);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    private static String formatPassword(String password) {
        int i = password.length() % 8;
        if (i != 0) {
            StringBuilder buffer = new StringBuilder(password);
            for (int j = i; j < 8; ++j) {
                buffer.append(0);
            }
            return buffer.toString();
        }
        return password;
    }

    public static void main(String[] args) {
        String formatPassword = DESUtils.formatPassword("1");
        System.out.println(formatPassword);
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        String password = "ABCDEFGH12345678";
        String encrypt = DESUtils.encrypt(srcStr, password);
        System.out.println(encrypt);
        String decrypt = DESUtils.decrypt(encrypt, password);
        System.out.println(decrypt);
    }
}

