/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class CharacterReader {
    private static final int BUFFER_SIZE = 1024;
    private final Reader reader;
    private final char[] buffer;
    private int pos;
    private int size;

    public CharacterReader(String reader) {
        this.reader = new StringReader(reader);
        this.buffer = new char[1024];
    }

    public char peek() {
        if (this.pos - 1 >= this.size) {
            return '\uffff';
        }
        return this.buffer[Math.max(0, this.pos - 1)];
    }

    public char peek(int c) {
        if (this.pos - c > this.size - 1) {
            return '\uffff';
        }
        return this.buffer[Math.max(0, this.pos - c)];
    }

    public char prep() {
        if (this.pos <= 0) {
            return this.buffer[0];
        }
        return this.buffer[Math.min(this.pos + 1, this.pos)];
    }

    public char next() throws IOException {
        if (!this.hasMore()) {
            return '\uffff';
        }
        return this.buffer[this.pos++];
    }

    public void back() {
        this.pos = Math.max(0, --this.pos);
    }

    public boolean hasMore() throws IOException {
        if (this.pos < this.size) {
            return true;
        }
        this.fillBuffer();
        return this.pos < this.size;
    }

    private void fillBuffer() throws IOException {
        int n = this.reader.read(this.buffer);
        if (n == -1) {
            return;
        }
        this.pos = 0;
        this.size = n;
    }
}

