/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.io;

import com.sondertara.common.exception.IORuntimeException;
import com.sondertara.common.exception.TaraException;
import com.sondertara.common.io.FileNameUtils;
import com.sondertara.common.io.FileReader;
import com.sondertara.common.io.IoUtils;
import com.sondertara.common.io.LineHandler;
import com.sondertara.common.io.PathUtils;
import com.sondertara.common.io.file.FileMode;
import com.sondertara.common.io.file.FileWriter;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.map.EnumerationIter;
import com.sondertara.common.lang.unit.DataSizeUtils;
import com.sondertara.common.util.ArrayUtils;
import com.sondertara.common.util.CharUtils;
import com.sondertara.common.util.ClassUtils;
import com.sondertara.common.util.RegexUtils;
import com.sondertara.common.util.ResourceUtils;
import com.sondertara.common.util.StringUtils;
import com.sondertara.common.util.URLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils
extends PathUtils {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");
    public static final String FILE_SEPARATOR = File.separator;
    public static final String PATH_SEPARATOR = File.pathSeparator;

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileUtils.file(path);
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new IORuntimeException(StringUtils.format("Path [{}] is not directory!", path), new Object[0]);
    }

    public static boolean isEmpty(File file) {
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            return ArrayUtils.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileUtils.isEmpty(file);
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtils.isDirEmpty(dir.toPath());
    }

    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        return FileUtils.loopFiles(FileUtils.file(path), fileFilter);
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        return FileUtils.loopFiles(file, -1, fileFilter);
    }

    public static void walkFiles(File file, Consumer<File> consumer) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (ArrayUtils.isNotEmpty(subFiles)) {
                for (File tmp : subFiles) {
                    FileUtils.walkFiles(tmp, consumer);
                }
            }
        } else {
            consumer.accept(file);
        }
    }

    public static List<File> loopFiles(File file, int maxDepth, FileFilter fileFilter) {
        return FileUtils.loopFiles(file.toPath(), maxDepth, fileFilter);
    }

    public static List<File> loopFiles(String path) {
        return FileUtils.loopFiles(FileUtils.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileUtils.loopFiles(file, null);
    }

    public static File newFile(String path) {
        return new File(path);
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(FileUtils.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        return FileUtils.file(new File(parent), path);
    }

    public static File file(File parent, String path) {
        if (StringUtils.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtils.checkSlip(parent, FileUtils.buildFile(parent, path));
    }

    public static File file(File directory, String ... names) {
        Assert.notNull(directory, "directory must not be null", new Object[0]);
        if (ArrayUtils.isEmpty(names)) {
            return directory;
        }
        File file = directory;
        for (String name : names) {
            if (null == name) continue;
            file = FileUtils.file(file, name);
        }
        return file;
    }

    public static File file(String ... names) {
        if (ArrayUtils.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : names) {
            file = file == null ? FileUtils.file(name) : FileUtils.file(file, name);
        }
        return file;
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(URLUtils.toURI(url));
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileUtils.file(FileUtils.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileUtils.file(FileUtils.getUserHomePath());
    }

    public static boolean exist(String path) {
        return null != path && FileUtils.file(path).exists();
    }

    public static boolean exist(File file) {
        return null != file && file.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileUtils.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileUtils.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        return FileUtils.size(file, false);
    }

    public static long size(File file, boolean includeDirSize) {
        if (null == file || !file.exists() || FileUtils.isSymlink(file)) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = includeDirSize ? file.length() : 0L;
            File[] subFiles = file.listFiles();
            if (ArrayUtils.isEmpty(subFiles)) {
                return 0L;
            }
            for (File subFile : subFiles) {
                size += FileUtils.size(subFile, includeDirSize);
            }
            return size;
        }
        return file.length();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getTotalLines(File file) {
        if (!FileUtils.isFile(file)) {
            throw new IORuntimeException("Input must be a File", new Object[0]);
        }
        try (LineNumberReader lineNumberReader = new LineNumberReader(new java.io.FileReader(file));){
            lineNumberReader.setLineNumber(1);
            lineNumberReader.skip(Long.MAX_VALUE);
            int n = lineNumberReader.getLineNumber();
            return n;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean newerThan(File file, File reference) {
        if (null == reference || !reference.exists()) {
            return true;
        }
        return FileUtils.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String path) throws IORuntimeException {
        if (path == null) {
            return null;
        }
        return FileUtils.touch(FileUtils.file(path));
    }

    public static File touch(File file) throws IORuntimeException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtils.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws IORuntimeException {
        return FileUtils.touch(FileUtils.file(parent, path));
    }

    public static File touch(String parent, String path) throws IORuntimeException {
        return FileUtils.touch(FileUtils.file(parent, path));
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileUtils.mkdir(FileUtils.getParent(file, 1));
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileUtils.mkParentDirs(FileUtils.file(path));
    }

    public static boolean del(String fullFileOrDirPath) throws IORuntimeException {
        return FileUtils.del(FileUtils.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws IORuntimeException {
        boolean isOk;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && !(isOk = FileUtils.clean(file))) {
            return false;
        }
        Path path = file.toPath();
        try {
            FileUtils.delFile(path);
        }
        catch (DirectoryNotEmptyException e) {
            FileUtils.del(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    public static boolean clean(String dirPath) throws IORuntimeException {
        return FileUtils.clean(FileUtils.file(dirPath));
    }

    public static boolean clean(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (null != files) {
            for (File childFile : files) {
                if (FileUtils.del(childFile)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean cleanEmpty(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            return directory.delete();
        }
        for (File childFile : files) {
            FileUtils.cleanEmpty(childFile);
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtils.file(dirPath);
        return FileUtils.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileUtils.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            try {
                Thread.sleep(sleepMillis);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return dir.exists();
    }

    public static File createTempFile(File dir) throws IORuntimeException {
        return FileUtils.createTempFile("tara", null, dir, true);
    }

    public static File createTempFile() throws IORuntimeException {
        return FileUtils.createTempFile("tara", null, null, true);
    }

    public static File createTempFile(String suffix, boolean isReCreat) throws IORuntimeException {
        return FileUtils.createTempFile("tara", suffix, null, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, boolean isReCreat) throws IORuntimeException {
        return FileUtils.createTempFile(prefix, suffix, null, isReCreat);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws IORuntimeException {
        return FileUtils.createTempFile("tara", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, FileUtils.mkdir(dir)).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws IORuntimeException {
        Assert.notBlank(src, "Source File path is blank !", new Object[0]);
        Assert.notBlank(dest, "Destination File path is blank !", new Object[0]);
        return FileUtils.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static void copyDirectory(String src, String dest) {
        try {
            Files.walk(Paths.get(src, new String[0]), new FileVisitOption[0]).forEach(source -> {
                Path destination = Paths.get(dest, source.toString().substring(src.length()));
                try {
                    Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new IORuntimeException("File not exist: " + src, new Object[0]);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtils.equals(src, dest)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", src, dest);
        }
        return FileUtils.copyFile(src.toPath(), dest.toPath(), options).toFile();
    }

    public static void move(File src, File target, boolean isOverride) throws IORuntimeException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtils.move(src.toPath(), target.toPath(), isOverride);
    }

    public static void moveContent(File src, File target, boolean isOverride) throws IORuntimeException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtils.moveContent(src.toPath(), target.toPath(), isOverride);
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return FileUtils.rename(file, newName, false, isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && StringUtils.isNotBlank(extName = FileUtils.extName(file))) {
            newName = newName.concat(".").concat(extName);
        }
        return FileUtils.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static String getCanonicalPath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileUtils.normalize(path);
            if (FileUtils.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtils.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtils.normalize(URLUtils.getDecodedPath(url));
        }
        String classPath = ClassUtils.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileUtils.normalize(classPath.concat(Objects.requireNonNull(path)));
    }

    public static String getAbsolutePath(String path) {
        return FileUtils.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || RegexUtils.isMatch(PATTERN_PATH_ABSOLUTE, (CharSequence)path);
    }

    public static boolean isDirectory(String path) {
        return null != path && FileUtils.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return null != file && file.isDirectory();
    }

    public static boolean isFile(String path) {
        return null != path && FileUtils.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean equals(File file1, File file2) throws IORuntimeException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileUtils.pathEquals(file1, file2);
        }
        return FileUtils.equals(file1.toPath(), file2.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws IORuntimeException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files", new Object[0]);
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtils.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            input1 = FileUtils.getInputStream(file1);
            input2 = FileUtils.getInputStream(file2);
            boolean bl = IoUtils.contentEquals(input1, input2);
            return bl;
        }
        finally {
            IoUtils.close(input1);
            IoUtils.close(input2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws IORuntimeException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files", new Object[0]);
        }
        if (FileUtils.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            input1 = FileUtils.getReader(file1, charset);
            input2 = FileUtils.getReader(file2, charset);
            bl = IoUtils.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            IoUtils.close(input1);
            IoUtils.close(input2);
            throw throwable;
        }
        IoUtils.close(input1);
        IoUtils.close(input2);
        return bl;
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileUtils.isWindows()) {
                try {
                    if (StringUtils.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (StringUtils.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StringUtils.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!StringUtils.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StringUtils.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!CharUtils.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    @Deprecated
    public static boolean isModifed(File file, long lastModifyTime) {
        return FileUtils.isModified(file, lastModifyTime);
    }

    public static boolean isModified(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.removePrefixIgnoreCase(path, "classpath:");
        if (StringUtils.startWith((CharSequence)(pathToUse = StringUtils.removePrefixIgnoreCase(pathToUse, "file:")), '~')) {
            pathToUse = FileUtils.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = StringUtils.trimStart(pathToUse);
        if (path.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StringUtils.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringUtils.split((CharSequence)pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StringUtils.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + String.join((CharSequence)"/", pathElements);
    }

    public static String subPath(String rootDir, File file) {
        try {
            return FileUtils.subPath(rootDir, file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String subPath(String dirPath, String filePath) {
        if (StringUtils.isNotEmpty(dirPath) && StringUtils.isNotEmpty(filePath)) {
            dirPath = StringUtils.removeSuffix(FileUtils.normalize(dirPath), "/");
            filePath = FileUtils.normalize(filePath);
            String result = StringUtils.removePrefixIgnoreCase(filePath, dirPath);
            return StringUtils.removePrefix(result, "/");
        }
        return filePath;
    }

    public static String getName(File file) {
        return FileNameUtils.getName(file);
    }

    public static String getName(String filePath) {
        return FileNameUtils.getName(filePath);
    }

    public static String getSuffix(File file) {
        return FileNameUtils.getSuffix(file);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtils.getSuffix(fileName);
    }

    public static String getPrefix(File file) {
        return FileNameUtils.getPrefix(file);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtils.getPrefix(fileName);
    }

    public static String mainName(File file) {
        return FileNameUtils.mainName(file);
    }

    public static String mainName(String fileName) {
        return FileNameUtils.mainName(fileName);
    }

    public static String extName(File file) {
        return FileNameUtils.extName(file);
    }

    public static String extName(String fileName) {
        return FileNameUtils.extName(fileName);
    }

    public static boolean pathEndsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static BufferedInputStream getInputStream(File file) throws IORuntimeException {
        return IoUtils.toBuffered(IoUtils.toStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws IORuntimeException {
        return FileUtils.getInputStream(FileUtils.file(path));
    }

    public static BufferedReader getUtf8Reader(File file) throws IORuntimeException {
        return FileUtils.getReader(file, StandardCharsets.UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws IORuntimeException {
        return FileUtils.getReader(path, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static BufferedReader getReader(File file, String charsetName) throws IORuntimeException {
        return IoUtils.getReader(FileUtils.getInputStream(file), Charset.forName(charsetName));
    }

    public static BufferedReader getReader(File file, Charset charset) throws IORuntimeException {
        return IoUtils.getReader(FileUtils.getInputStream(file), charset);
    }

    @Deprecated
    public static BufferedReader getReader(String path, String charsetName) throws IORuntimeException {
        return FileUtils.getReader(path, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(String path, Charset charset) throws IORuntimeException {
        return FileUtils.getReader(FileUtils.file(path), charset);
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    public static byte[] readBytes(String filePath) throws IORuntimeException {
        return FileUtils.readBytes(FileUtils.file(filePath));
    }

    public static String readUtf8String(File file) throws IORuntimeException {
        return FileUtils.readString(file, StandardCharsets.UTF_8);
    }

    public static String readUtf8String(String path) throws IORuntimeException {
        return FileUtils.readString(path, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String readString(File file, String charsetName) throws IORuntimeException {
        return FileUtils.readString(file, Charset.forName(charsetName));
    }

    public static String readString(File file, Charset charset) throws IORuntimeException {
        return FileReader.create(file, charset).readString();
    }

    @Deprecated
    public static String readString(String path, String charsetName) throws IORuntimeException {
        return FileUtils.readString(path, Charset.forName(charsetName));
    }

    public static String readString(String path, Charset charset) throws IORuntimeException {
        return FileUtils.readString(FileUtils.file(path), charset);
    }

    @Deprecated
    public static String readString(URL url, String charsetName) throws IORuntimeException {
        return FileUtils.readString(url, Charset.forName(charsetName));
    }

    public static String readString(URL url, Charset charset) throws IORuntimeException {
        if (url == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(String path, T collection) throws IORuntimeException {
        return FileUtils.readLines(path, StandardCharsets.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IORuntimeException {
        return FileUtils.readLines(FileUtils.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws IORuntimeException {
        return FileUtils.readLines(FileUtils.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(File file, T collection) throws IORuntimeException {
        return FileUtils.readLines(file, StandardCharsets.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws IORuntimeException {
        return FileReader.create(file, Charset.forName(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws IORuntimeException {
        return FileReader.create(file, charset).readLines(collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(URL url, T collection) throws IORuntimeException {
        return FileUtils.readLines(url, StandardCharsets.UTF_8, collection);
    }

    @Deprecated
    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws IORuntimeException {
        return FileUtils.readLines(url, Charset.forName(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtils.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static List<String> readUtf8Lines(URL url) throws IORuntimeException {
        return FileUtils.readLines(url, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static List<String> readLines(URL url, String charsetName) throws IORuntimeException {
        return FileUtils.readLines(url, Charset.forName(charsetName));
    }

    public static List<String> readLines(URL url, Charset charset) throws IORuntimeException {
        return FileUtils.readLines(url, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(String path) throws IORuntimeException {
        return FileUtils.readLines(path, StandardCharsets.UTF_8);
    }

    public static List<String> readLines(String path, String charset) throws IORuntimeException {
        return FileUtils.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(String path, Charset charset) throws IORuntimeException {
        return FileUtils.readLines(path, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(File file) throws IORuntimeException {
        return FileUtils.readLines(file, StandardCharsets.UTF_8);
    }

    public static List<String> readLines(File file, String charset) throws IORuntimeException {
        return FileUtils.readLines(file, charset, new ArrayList());
    }

    public static List<String> readLines(File file, Charset charset) throws IORuntimeException {
        return FileUtils.readLines(file, charset, new ArrayList());
    }

    public static void readUtf8Lines(File file, LineHandler lineHandler) throws IORuntimeException {
        FileUtils.readLines(file, StandardCharsets.UTF_8, lineHandler);
    }

    public static void readLines(File file, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        FileReader.create(file, charset).readLines(lineHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) throws IORuntimeException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(FileUtils.touch(file));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtils.toBuffered(out);
    }

    public static BufferedOutputStream getOutputStream(String path) throws IORuntimeException {
        return FileUtils.getOutputStream(FileUtils.touch(path));
    }

    @Deprecated
    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtils.getWriter(path, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileUtils.getWriter(FileUtils.touch(path), charset, isAppend);
    }

    @Deprecated
    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtils.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtils.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(String path, Charset charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtils.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtils.getWriter(file, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtils.getWriter(file, charset, isAppend));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeUtf8String(String content, String path) throws IORuntimeException {
        return FileUtils.writeString(content, path, StandardCharsets.UTF_8);
    }

    public static File writeUtf8String(String content, File file) throws IORuntimeException {
        return FileUtils.writeString(content, file, StandardCharsets.UTF_8);
    }

    public static File writeString(String content, String path, String charset) throws IORuntimeException {
        return FileUtils.writeString(content, FileUtils.touch(path), charset);
    }

    public static File writeString(String content, String path, Charset charset) throws IORuntimeException {
        return FileUtils.writeString(content, FileUtils.touch(path), charset);
    }

    public static File writeString(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, Charset.forName(charset)).write(content);
    }

    public static File writeString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).write(content);
    }

    public static File appendUtf8String(String content, String path) throws IORuntimeException {
        return FileUtils.appendString(content, path, StandardCharsets.UTF_8);
    }

    public static File appendString(String content, String path, String charset) throws IORuntimeException {
        return FileUtils.appendString(content, FileUtils.touch(path), charset);
    }

    public static File appendString(String content, String path, Charset charset) throws IORuntimeException {
        return FileUtils.appendString(content, FileUtils.touch(path), charset);
    }

    public static File appendUtf8String(String content, File file) throws IORuntimeException {
        return FileUtils.appendString(content, file, StandardCharsets.UTF_8);
    }

    public static File appendString(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, Charset.forName(charset)).append(content);
    }

    public static File appendString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).append(content);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, String path) throws IORuntimeException {
        return FileUtils.writeLines(list, path, StandardCharsets.UTF_8);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, File file) throws IORuntimeException {
        return FileUtils.writeLines(list, file, StandardCharsets.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        return FileUtils.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset) throws IORuntimeException {
        return FileUtils.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset) throws IORuntimeException {
        return FileUtils.writeLines(list, file, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset) throws IORuntimeException {
        return FileUtils.writeLines(list, file, charset, false);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, File file) throws IORuntimeException {
        return FileUtils.appendLines(list, file, StandardCharsets.UTF_8);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, String path) throws IORuntimeException {
        return FileUtils.appendLines(list, path, StandardCharsets.UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        return FileUtils.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, String charset) throws IORuntimeException {
        return FileUtils.writeLines(list, file, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, String path, Charset charset) throws IORuntimeException {
        return FileUtils.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, Charset charset) throws IORuntimeException {
        return FileUtils.writeLines(list, file, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IORuntimeException {
        return FileUtils.writeLines(list, FileUtils.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileUtils.writeLines(list, FileUtils.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, Charset.forName(charset)).writeLines(list, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, charset).writeLines(list, isAppend);
    }

    public static File writeUtf8Map(Map<?, ?> map, File file, String kvSeparator, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, StandardCharsets.UTF_8).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeMap(Map<?, ?> map, File file, Charset charset, String kvSeparator, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, charset).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeBytes(byte[] data, String path) throws IORuntimeException {
        return FileUtils.writeBytes(data, FileUtils.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws IORuntimeException {
        return FileUtils.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(dest).write(data, off, len, isAppend);
    }

    public static File writeFromStream(InputStream in, File dest) throws IORuntimeException {
        return FileUtils.writeFromStream(in, dest, true);
    }

    public static File writeFromStream(InputStream in, File dest, boolean isCloseIn) throws IORuntimeException {
        return FileWriter.create(dest).writeFromStream(in, isCloseIn);
    }

    public static File writeFromStream(InputStream in, String fullFilePath) throws IORuntimeException {
        return FileUtils.writeFromStream(in, FileUtils.touch(fullFilePath));
    }

    public static long writeToStream(File file, OutputStream out) throws IORuntimeException {
        return FileReader.create(file).writeToStream(out);
    }

    public static long writeToStream(String fullFilePath, OutputStream out) throws IORuntimeException {
        return FileUtils.writeToStream(FileUtils.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file) {
        return FileUtils.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        return DataSizeUtils.format(size);
    }

    public static String cleanInvalid(String fileName) {
        return FileNameUtils.cleanInvalid(fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return FileNameUtils.containsInvalid(fileName);
    }

    public static long checksumCRC32(File file) throws IORuntimeException {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws IORuntimeException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return IoUtils.checksum(new FileInputStream(file), checksum);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getWebRoot() {
        String classPath = ClassUtils.getClassPath();
        if (StringUtils.isNotBlank(classPath)) {
            return FileUtils.getParent(FileUtils.file(classPath), 2);
        }
        return null;
    }

    public static String getParent(String filePath, int level) {
        File parent = FileUtils.getParent(FileUtils.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtils.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file) {
            String canonicalPath;
            String parentCanonicalPath;
            try {
                parentCanonicalPath = parentFile.getCanonicalPath();
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                parentCanonicalPath = parentFile.getAbsolutePath();
                canonicalPath = file.getAbsolutePath();
            }
            if (!canonicalPath.startsWith(parentCanonicalPath)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
            }
        }
        return file;
    }

    public static String getMimeType(String filePath) {
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (null == contentType) {
            if (StringUtils.endWithIgnoreCase(filePath, ".css")) {
                contentType = "text/css";
            } else if (StringUtils.endWithIgnoreCase(filePath, ".js")) {
                contentType = "application/x-javascript";
            } else if (StringUtils.endWithIgnoreCase(filePath, ".rar")) {
                contentType = "application/x-rar-compressed";
            } else if (StringUtils.endWithIgnoreCase(filePath, ".7z")) {
                contentType = "application/x-7z-compressed";
            }
        }
        if (null == contentType) {
            contentType = FileUtils.getMimeType(Paths.get(filePath, new String[0]));
        }
        return contentType;
    }

    public static boolean isSymlink(File file) {
        return FileUtils.isSymlink(file.toPath());
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileUtils.isSub(parent.toPath(), sub.toPath());
    }

    public static RandomAccessFile createRandomAccessFile(Path path, FileMode mode) {
        return FileUtils.createRandomAccessFile(path.toFile(), mode);
    }

    public static RandomAccessFile createRandomAccessFile(File file, FileMode mode) {
        try {
            return new RandomAccessFile(file, mode.name());
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileUtils.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = StringUtils.split(fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }

    public static boolean remove(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())).forEach(FileUtils::remove);
        return file.delete();
    }

    public static boolean remove(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())).forEach(FileUtils::remove);
        return file.delete();
    }

    public static boolean removeParent(File file, int depth) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File parentFile = file.getParentFile();
        for (int i = 1; i < depth; ++i) {
            parentFile = parentFile.getParentFile();
        }
        if (null == parentFile) {
            return false;
        }
        return FileUtils.remove(parentFile);
    }

    public static BasicFileAttributes getAttributes(String filePath) throws IOException {
        return Files.readAttributes(new File(filePath).toPath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    public static LocalDateTime getTimeCreate(String filePath) throws IOException {
        return LocalDateTime.ofInstant(FileUtils.getAttributes(filePath).creationTime().toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime getTimeLastModify(String filePath) throws IOException {
        return LocalDateTime.ofInstant(FileUtils.getAttributes(filePath).lastModifiedTime().toInstant(), ZoneId.systemDefault());
    }

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static List<String> listFileNames(String path) throws TaraException {
        List<String> files2;
        if (path == null) {
            return new ArrayList<String>(0);
        }
        int index = path.lastIndexOf(JAR_PATH_EXT);
        if (index < 0) {
            File[] files2;
            ArrayList<String> paths = new ArrayList<String>();
            for (File file : files2 = FileUtils.ls(path)) {
                if (!file.isFile()) continue;
                paths.add(file.getName());
            }
            return paths;
        }
        path = FileUtils.getAbsolutePath(path);
        index += JAR_FILE_EXT.length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path.substring(0, index));
            files2 = FileUtils.listFileNames(jarFile, StringUtils.removePrefix(path.substring(index + 1), "/"));
        }
        catch (IOException e) {
            try {
                throw new TaraException(StringUtils.format("Can not read file path of [{}]", path), e);
            }
            catch (Throwable throwable) {
                IoUtils.close(jarFile);
                throw throwable;
            }
        }
        IoUtils.close(jarFile);
        return files2;
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StringUtils.isNotBlank(dir)) {
            dir = StringUtils.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : new EnumerationIter<ZipEntry>(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StringUtils.isEmpty(dir) && !name.startsWith(dir) || !StringUtils.isNotEmpty(nameSuffix = StringUtils.removePrefix(name, dir)) || StringUtils.contains((CharSequence)nameSuffix, '/')) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }
}

