/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.io;

import com.sondertara.common.exception.IORuntimeException;
import com.sondertara.common.io.FastByteArrayOutputStream;
import com.sondertara.common.io.LineHandler;
import com.sondertara.common.io.NioUtils;
import com.sondertara.common.io.StreamProgress;
import com.sondertara.common.io.copy.ReaderWriterCopier;
import com.sondertara.common.io.copy.StreamCopier;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.util.HexUtils;
import com.sondertara.common.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.NullOutputStream;

public class IoUtils
extends NioUtils {
    public static final int BUFFER_SIZE = 4096;

    public static long copy(Reader reader, Writer writer) throws IORuntimeException {
        return IoUtils.copy(reader, writer, 8192);
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull(in, "No input byte array specified", new Object[0]);
        Assert.notNull(out, "No OutputStream specified", new Object[0]);
        out.write(in);
        out.flush();
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IORuntimeException {
        return IoUtils.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtils.copy(reader, writer, bufferSize, -1L, streamProgress);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return new ReaderWriterCopier(bufferSize, count, streamProgress).copy(reader, writer);
    }

    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return IoUtils.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return IoUtils.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtils.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        long l;
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = IoUtils.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IoUtils.close(outChannel);
            IoUtils.close(inChannel);
            throw throwable;
        }
        IoUtils.close(outChannel);
        IoUtils.close(inChannel);
        return l;
    }

    public static BufferedReader getUtf8Reader(InputStream in) {
        return IoUtils.getReader(in, StandardCharsets.UTF_8);
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getUtf8Writer(OutputStream out) {
        return IoUtils.getWriter(out, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoUtils.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String readUtf8(InputStream in) throws IORuntimeException {
        return IoUtils.read(in, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String read(InputStream in, String charsetName) throws IORuntimeException {
        FastByteArrayOutputStream out = IoUtils.read(in);
        return StringUtils.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        return StringUtils.str(IoUtils.readBytes(in), charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IORuntimeException {
        return IoUtils.read(in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IORuntimeException {
        FastByteArrayOutputStream out;
        if (in instanceof FileInputStream) {
            try {
                out = new FastByteArrayOutputStream(in.available());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        } else {
            out = new FastByteArrayOutputStream();
        }
        try {
            IoUtils.copy(in, (OutputStream)out);
        }
        finally {
            if (isClose) {
                IoUtils.close(in);
            }
        }
        return out;
    }

    public static String read(Reader reader) throws IORuntimeException {
        return IoUtils.read(reader, true);
    }

    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        StringBuilder builder = StringUtils.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isClose) {
                IoUtils.close(reader);
            }
        }
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return IoUtils.readBytes(in, true);
    }

    public static String copyToString(InputStream in, Charset charset) throws IOException {
        int charsRead;
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(4096);
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        while ((charsRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, charsRead);
        }
        return out.toString();
    }

    public static byte[] copyToByteArray(InputStream in) throws IORuntimeException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IoUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        if (in instanceof FileInputStream) {
            byte[] result;
            try {
                int available = in.available();
                result = new byte[available];
                int readLength = in.read(result);
                if (readLength != available) {
                    throw new IOException(StringUtils.format("File length is [{}] but read [{}]!", available, readLength));
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            finally {
                if (isClose) {
                    IoUtils.close(in);
                }
            }
            return result;
        }
        return IoUtils.read(in, isClose).toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws IORuntimeException {
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(length);
        IoUtils.copy(in, out, 8192, (long)length, null);
        return out.toByteArray();
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IORuntimeException {
        return HexUtils.encodeHexStr(IoUtils.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws IORuntimeException {
        return IoUtils.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws IORuntimeException {
        return IoUtils.readHex(in, 28, true);
    }

    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws IORuntimeException {
        return IoUtils.readLines(in, StandardCharsets.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IORuntimeException {
        return IoUtils.readLines((Reader)IoUtils.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws IORuntimeException {
        IoUtils.readLines(reader, collection::add);
        return collection;
    }

    public static void readUtf8Lines(InputStream in, LineHandler lineHandler) throws IORuntimeException {
        IoUtils.readLines(in, StandardCharsets.UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        IoUtils.readLines((Reader)IoUtils.getReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, LineHandler lineHandler) throws IORuntimeException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        LineIterator it = IoUtils.lineIter(reader);
        while (it.hasNext()) {
            String line = it.next();
            lineHandler.handle(line);
        }
    }

    @Deprecated
    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IoUtils.toStream(content, Charset.forName(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoUtils.toStream(StringUtils.bytes((CharSequence)content, charset));
    }

    public static ByteArrayInputStream toUtf8Stream(String content) {
        return IoUtils.toStream(content, StandardCharsets.UTF_8);
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static ByteArrayInputStream toStream(ByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedInputStream toBuffered(InputStream in, int bufferSize) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in, bufferSize);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedOutputStream toBuffered(OutputStream out, int bufferSize) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, bufferSize);
    }

    public static BufferedReader toBuffered(Reader reader) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBuffered(Reader reader, int bufferSize) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, bufferSize);
    }

    public static BufferedWriter toBuffered(Writer writer) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter toBuffered(Writer writer, int bufferSize) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, bufferSize);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    public static InputStream toAvailableStream(InputStream in) {
        if (in instanceof FileInputStream) {
            return in;
        }
        PushbackInputStream pushbackInputStream = IoUtils.toPushbackStream(in, 1);
        try {
            int available = pushbackInputStream.available();
            if (available <= 0) {
                int b = pushbackInputStream.read();
                pushbackInputStream.unread(b);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return pushbackInputStream;
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtils.close(out);
            }
        }
    }

    public static void writeObj(OutputStream out, boolean isCloseOut, Serializable obj) throws IORuntimeException {
        IoUtils.writeObjects(out, isCloseOut, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtils.close(osw);
                throw throwable;
            }
        }
        IoUtils.close(osw);
        return;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(Object obj) {
        if (obj instanceof AutoCloseable) {
            IoUtils.close((AutoCloseable)obj);
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IORuntimeException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IORuntimeException {
        input1 = IoUtils.getReader(input1);
        input2 = IoUtils.getReader(input2);
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IORuntimeException {
        BufferedReader br1 = IoUtils.getReader(input1);
        BufferedReader br2 = IoUtils.getReader(input2);
        try {
            String line1 = br1.readLine();
            String line2 = br2.readLine();
            while (line1 != null && line1.equals(line2)) {
                line1 = br1.readLine();
                line2 = br2.readLine();
            }
            return Objects.equals(line1, line2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long checksumCRC32(InputStream in) throws IORuntimeException {
        return IoUtils.checksum(in, new CRC32()).getValue();
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IoUtils.copy(in, (OutputStream)new NullOutputStream());
        }
        finally {
            IoUtils.close(in);
        }
        return checksum;
    }

    public static long checksumValue(InputStream in, Checksum checksum) {
        return IoUtils.checksum(in, checksum).getValue();
    }

    public static LineIterator lineIter(Reader reader) {
        return new LineIterator(reader);
    }

    public static String toStr(ByteArrayOutputStream out, Charset charset) {
        try {
            return out.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }
}

