/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.io;

import com.sondertara.common.exception.IORuntimeException;
import com.sondertara.common.io.FastByteArrayOutputStream;
import com.sondertara.common.io.StreamProgress;
import com.sondertara.common.io.copy.ChannelCopier;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class NioUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return NioUtils.copyByNIO(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return NioUtils.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, count, streamProgress);
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws IORuntimeException {
        Assert.notNull(inChannel, "In channel is null!", new Object[0]);
        Assert.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            return NioUtils.copySafely(inChannel, outChannel);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static long copySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IORuntimeException {
        return NioUtils.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IORuntimeException {
        return NioUtils.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return NioUtils.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return new ChannelCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IORuntimeException {
        FastByteArrayOutputStream out = NioUtils.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        NioUtils.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return NioUtils.read(fileChannel, StandardCharsets.UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IORuntimeException {
        return NioUtils.read(fileChannel, Charset.forName(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StringUtils.str((ByteBuffer)buffer, charset);
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

