/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.io.file;

import com.sondertara.common.exception.IORuntimeException;
import com.sondertara.common.io.FileUtils;
import com.sondertara.common.io.IoUtils;
import com.sondertara.common.io.file.FileWrapper;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file, String charset) {
        this(file, Charset.forName(charset));
    }

    public FileWriter(String filePath, Charset charset) {
        this(FileUtils.file(filePath), charset);
    }

    public FileWriter(String filePath, String charset) {
        this(FileUtils.file(filePath), Charset.forName(charset));
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileWriter(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public File write(String content, boolean isAppend) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtils.close(writer);
        }
        return this.file;
    }

    public File write(String content) throws IORuntimeException {
        return this.write(content, false);
    }

    public File append(String content) throws IORuntimeException {
        return this.write(content, true);
    }

    public <T> File writeLines(Iterable<T> list) throws IORuntimeException {
        return this.writeLines(list, false);
    }

    public <T> File appendLines(Iterable<T> list) throws IORuntimeException {
        return this.writeLines(list, true);
    }

    public <T> File writeLines(Iterable<T> list, boolean isAppend) throws IORuntimeException {
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            boolean isFirst = true;
            for (T t : list) {
                if (null == t) continue;
                if (isFirst) {
                    isFirst = false;
                    if (isAppend && FileUtils.isNotEmpty(this.file)) {
                        this.printNewLine(writer);
                    }
                } else {
                    this.printNewLine(writer);
                }
                writer.print(t);
                writer.flush();
            }
        }
        return this.file;
    }

    public File writeMap(Map<?, ?> map, String kvSeparator, boolean isAppend) throws IORuntimeException {
        if (null == kvSeparator) {
            kvSeparator = " = ";
        }
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (null == entry) continue;
                writer.print(StringUtils.format("{}{}{}", entry.getKey(), kvSeparator, entry.getValue()));
                this.printNewLine(writer);
                writer.flush();
            }
        }
        return this.file;
    }

    public File write(byte[] data, int off, int len) throws IORuntimeException {
        return this.write(data, off, len, false);
    }

    public File append(byte[] data, int off, int len) throws IORuntimeException {
        return this.write(data, off, len, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws IORuntimeException {
        try (FileOutputStream out = new FileOutputStream(FileUtils.touch(this.file), isAppend);){
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.file;
    }

    public File writeFromStream(InputStream in) throws IORuntimeException {
        return this.writeFromStream(in, true);
    }

    public File writeFromStream(InputStream in, boolean isCloseIn) throws IORuntimeException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtils.touch(this.file));
            IoUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                if (isCloseIn) {
                    IoUtils.close(in);
                }
                throw throwable;
            }
        }
        IoUtils.close(out);
        if (isCloseIn) {
            IoUtils.close(in);
        }
        return this.file;
    }

    public BufferedOutputStream getOutputStream() throws IORuntimeException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileUtils.touch(this.file)));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public BufferedWriter getWriter(boolean isAppend) throws IORuntimeException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) throws IORuntimeException {
        return new PrintWriter(this.getWriter(isAppend));
    }

    private void checkFile() throws IORuntimeException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    private void printNewLine(PrintWriter writer) {
        writer.println();
    }
}

