/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang;

import com.sondertara.common.function.JoinFunction;
import com.sondertara.common.function.KeyExtractor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Join {
    public static <K, V1, V2, R> Map<K, R> loopJoin(Collection<V1> coll1, Collection<V2> coll2, KeyExtractor<K, V1> extractor1, KeyExtractor<K, V2> extractor2, JoinFunction<K, V1, V2, R> joinFunction) {
        HashMap<K, R> results = new HashMap<K, R>();
        block0: for (V2 v2 : coll2) {
            K key = extractor2.extract(v2);
            for (V1 v1 : coll1) {
                if (!extractor1.extract(v1).equals(key)) continue;
                results.put(key, joinFunction.compute(key, v1, v2));
                continue block0;
            }
        }
        return results;
    }

    public static <K, V1, V2, R> Map<K, R> hashJoin(Collection<V1> coll1, Collection<V2> coll2, KeyExtractor<K, V1> extractor1, KeyExtractor<K, V2> extractor2, JoinFunction<K, V1, V2, R> joinFunction) {
        HashMap<K, R> results = new HashMap<K, R>();
        HashMap<K, V1> map1 = new HashMap<K, V1>();
        for (V1 v1 : coll1) {
            map1.put(extractor1.extract(v1), v1);
        }
        for (Object v2 : coll2) {
            K key = extractor2.extract(v2);
            Object v1 = map1.get(key);
            if (v1 == null) continue;
            R result = joinFunction.compute(key, v1, v2);
            results.put(key, result);
        }
        return results;
    }

    public static <K, V1, V2, R> Map<K, R> mapsJoin(Map<K, V1> map1, Map<K, V2> map2, JoinFunction<K, V1, V2, R> joinFunction) {
        HashMap<K, R> results = new HashMap<K, R>();
        for (Map.Entry<K, V1> entry1 : map1.entrySet()) {
            K key = entry1.getKey();
            V2 v2 = map2.get(key);
            if (v2 == null) continue;
            R result = joinFunction.compute(key, entry1.getValue(), v2);
            results.put(key, result);
        }
        return results;
    }
}

