/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.id;

public class MeteorId {
    private static final long initSecond = 1640966400L;
    private static final long nodeBits = 20L;
    private static final long seqBits = 11L;
    private static final long randBits = 3L;
    private static final long secBits = 29L;
    private static final long maxSecond = 0x1FFFFFFFL;
    private static final long maxNode = 1048575L;
    private static final long maxSeq = 0x1FFFFFFFL;
    private static final long maxRand = 7L;
    private static final long timeShift = 34L;
    private static final long nodeShift = 14L;
    private static final long seqShift = 3L;
    private static final Node INSTANCE = new Node(0L);

    public static long nextId() {
        return INSTANCE.nexId();
    }

    public static void setNodeId(long nodeId) {
        INSTANCE.setNodeId(nodeId);
    }

    private static long rand(Node node) {
        Node node2 = node;
        node2.seed = node2.seed ^ node.seed << 7;
        node2 = node;
        node2.seed = node2.seed ^ node.seed >> 9;
        node2 = node;
        node2.seed = node2.seed ^ node.seed << 8;
        return node.seed % 7L;
    }

    static class Node {
        private long seqNum;
        private long randNum;
        private long second;
        private long seed;
        private long nodeId;

        public Node(long nodeId) {
            if (nodeId < 0L || nodeId > 1048575L) {
                throw new IllegalArgumentException("Node id must between 0 and 1048575");
            }
            this.nodeId = nodeId;
            this.seqNum = 0L;
            this.randNum = 0L;
            this.seed = 1L;
            this.second = System.currentTimeMillis() / 1000L - 1640966400L;
        }

        public synchronized long nexId() {
            this.seqNum = this.seqNum + 1L & 0x1FFFFFFFL;
            this.randNum = MeteorId.rand(this);
            if (this.seqNum == 0L) {
                this.second = this.second + 1L & 0x1FFFFFFFL;
                if (this.second == 0L) {
                    throw new IllegalStateException("Seconds overflow. The max second is 536870911");
                }
            }
            return this.second << 34 | this.nodeId << 14 | this.seqNum << 3 | this.randNum;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }
    }
}

