/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.id;

import com.sondertara.common.util.ClassLoaderUtils;
import com.sondertara.common.util.RandomUtils;
import com.sondertara.common.util.StringUtils;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectId {
    private static final AtomicInteger NEXT_INC = new AtomicInteger(RandomUtils.randomInt());
    private static final int MACHINE = ObjectId.getMachinePiece() | ObjectId.getProcessPiece();

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = (s = StringUtils.removeAll((CharSequence)s, "-")).length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static byte[] nextBytes() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putLong(System.currentTimeMillis() / 1000L);
        bb.putLong(MACHINE);
        bb.putLong(NEXT_INC.getAndIncrement());
        return bb.array();
    }

    public static String next() {
        return ObjectId.next(false);
    }

    public static String next(boolean withHyphen) {
        byte[] array = ObjectId.nextBytes();
        StringBuilder buf = new StringBuilder(withHyphen ? 26 : 24);
        for (int i = 0; i < array.length; ++i) {
            int t;
            if (withHyphen && i % 4 == 0 && i != 0) {
                buf.append("-");
            }
            if ((t = array[i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(t));
        }
        return buf.toString();
    }

    private static int getMachinePiece() {
        int machinePiece;
        try {
            StringBuilder netSb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                netSb.append(ni.toString());
            }
            machinePiece = netSb.toString().hashCode() << 16;
        }
        catch (Throwable e) {
            machinePiece = RandomUtils.randomInt() << 16;
        }
        return machinePiece;
    }

    private static int getProcessPiece() {
        long processId;
        try {
            processId = Thread.currentThread().getId();
        }
        catch (Throwable t) {
            processId = RandomUtils.randomLong();
        }
        ClassLoader loader = ClassLoaderUtils.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        String processSb = Long.toHexString(processId) + Integer.toHexString(loaderId);
        int processPiece = processSb.hashCode() & 0xFFFF;
        return processPiece;
    }
}

