/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.loader;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.io.FileUtils;
import com.sondertara.common.lang.reflect.ReflectUtils;
import com.sondertara.common.util.ClassUtils;
import com.sondertara.common.util.URLUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    public static JarClassLoader load(File dir) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(jarFile);
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) {
        try {
            Method method = ClassUtils.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtils.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassUtils.getClassLoader());
    }

    public JarClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    public JarClassLoader addJar(File jarFileOrDir) {
        if (JarClassLoader.isJarFile(jarFileOrDir)) {
            return this.addURL(jarFileOrDir);
        }
        List<File> jars = JarClassLoader.loopJar(jarFileOrDir);
        for (File jar : jars) {
            this.addURL(jar);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarClassLoader addURL(File dir) {
        super.addURL(URLUtils.getURL(dir));
        return this;
    }

    private static List<File> loopJar(File file) {
        return FileUtils.loopFiles(file, JarClassLoader::isJarFile);
    }

    private static boolean isJarFile(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }
}

