/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.map;

import com.sondertara.common.function.Func0;
import com.sondertara.common.util.ReferenceUtils;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReferenceConcurrentMap<K, V>
implements ConcurrentMap<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable {
    final ConcurrentMap<Reference<K>, V> raw;
    private final ReferenceQueue<K> lastQueue;
    private final ReferenceUtils.ReferenceType keyType;
    private BiConsumer<Reference<? extends K>, V> purgeListener;

    public ReferenceConcurrentMap(ConcurrentMap<Reference<K>, V> raw, ReferenceUtils.ReferenceType referenceType) {
        this.raw = raw;
        this.keyType = referenceType;
        this.lastQueue = new ReferenceQueue();
    }

    public void setPurgeListener(BiConsumer<Reference<? extends K>, V> purgeListener) {
        this.purgeListener = purgeListener;
    }

    @Override
    public int size() {
        this.purgeStaleKeys();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public V get(Object key) {
        this.purgeStaleKeys();
        return this.raw.get(this.ofKey(key, null));
    }

    @Override
    public boolean containsKey(Object key) {
        this.purgeStaleKeys();
        return this.raw.containsKey(this.ofKey(key, null));
    }

    @Override
    public boolean containsValue(Object value) {
        this.purgeStaleKeys();
        return this.raw.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        this.purgeStaleKeys();
        return this.raw.put(this.ofKey(key, this.lastQueue), value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.purgeStaleKeys();
        return this.raw.putIfAbsent(this.ofKey(key, this.lastQueue), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public V replace(K key, V value) {
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(key, this.lastQueue), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(key, this.lastQueue), oldValue, newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.purgeStaleKeys();
        this.raw.replaceAll((kWeakKey, value) -> function.apply((Object)kWeakKey.get(), (Object)value));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.computeIfAbsent(this.ofKey(key, this.lastQueue), (? super K kWeakKey) -> mappingFunction.apply((Object)key));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.computeIfPresent(this.ofKey(key, this.lastQueue), (kWeakKey, value) -> remappingFunction.apply((Object)key, (Object)value));
    }

    public V computeIfAbsent(K key, Func0<? extends V> supplier) {
        return (V)this.computeIfAbsent(key, (? super K keyParam) -> supplier.call());
    }

    @Override
    public V remove(Object key) {
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(key, null));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(key, null), value);
    }

    @Override
    public void clear() {
        this.raw.clear();
        while (this.lastQueue.poll() != null) {
        }
    }

    @Override
    public Set<K> keySet() {
        return this.raw.keySet().stream().map(Reference::get).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        this.purgeStaleKeys();
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.purgeStaleKeys();
        return this.raw.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(((Reference)entry.getKey()).get(), entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.purgeStaleKeys();
        this.raw.forEach((? super K key, ? super V value) -> action.accept((Object)key.get(), (Object)value));
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.compute(this.ofKey(key, this.lastQueue), (kWeakKey, value) -> remappingFunction.apply((Object)key, (Object)value));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return this.raw.merge((Reference<Reference<K>>)this.ofKey(key, this.lastQueue), (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    private void purgeStaleKeys() {
        Reference<K> reference;
        while ((reference = this.lastQueue.poll()) != null) {
            Object value = this.raw.remove(reference);
            if (null == this.purgeListener) continue;
            this.purgeListener.accept(reference, value);
        }
    }

    private Reference<K> ofKey(K key, ReferenceQueue<? super K> queue) {
        switch (this.keyType) {
            case WEAK: {
                return new WeakKey<K>(key, queue);
            }
            case SOFT: {
                return new SoftKey<K>(key, queue);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + (Object)((Object)this.keyType));
    }

    private static class SoftKey<K>
    extends SoftReference<K> {
        private final int hashCode;

        SoftKey(K key, ReferenceQueue<? super K> queue) {
            super(key, queue);
            this.hashCode = key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof SoftKey) {
                return Objects.equals(((SoftKey)other).get(), this.get());
            }
            return false;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        WeakKey(K key, ReferenceQueue<? super K> queue) {
            super(key, queue);
            this.hashCode = key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeakKey) {
                return Objects.equals(((WeakKey)other).get(), this.get());
            }
            return false;
        }
    }
}

