/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.reflect;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sondertara.common.convert.ConvertUtils;
import com.sondertara.common.exception.TaraException;
import com.sondertara.common.function.Filter;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.map.WeakConcurrentMap;
import com.sondertara.common.util.ArrayUtils;
import com.sondertara.common.util.ClassUtils;
import com.sondertara.common.util.MethodHandleUtils;
import com.sondertara.common.util.ModifierUtils;
import com.sondertara.common.util.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtils {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtils.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtils.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtils.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtils.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != ReflectUtils.getField(beanClass, name);
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        return field.getName();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtils.getFields(beanClass);
        return Arrays.stream(fields).filter(field -> name.equals(field.getName())).findFirst().orElse(null);
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = ReflectUtils.getFields(beanClass);
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtils.getFieldsDirectly(beanClass, true));
    }

    public static Field[] getFields(Class<?> beanClass, Filter<Field> fieldFilter) throws SecurityException {
        return ArrayUtils.filter(ReflectUtils.getFields(beanClass), fieldFilter);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtils.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (null == obj || StringUtils.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) {
        return ReflectUtils.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtils.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new TaraException("IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName(), e);
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectUtils.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectUtils.getFieldValue(obj, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectUtils.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        ReflectUtils.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = ConvertUtils.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassUtils.getDefaultValue(fieldType);
        }
        ReflectUtils.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new TaraException("IllegalAccess for {}.{}", obj, field.getName(), e);
        }
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        List<Method> methodArray = ReflectUtils.getPublicMethods(clazz);
        if (ArrayUtils.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static List<Method> getPublicMethods(Class<?> clazz) {
        return null == clazz ? Collections.emptyList() : Arrays.asList(clazz.getMethods());
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        if (null == clazz) {
            return Collections.emptyList();
        }
        List<Method> methods = ReflectUtils.getPublicMethods(clazz);
        if (null == filter) {
            return methods;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!filter.accept(method)) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet excludeMethodSet = Sets.newHashSet((Object[])excludeMethods);
        return ReflectUtils.getPublicMethods(clazz, (Method method) -> !excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet excludeMethodNameSet = Sets.newHashSet((Object[])excludeMethodNames);
        return ReflectUtils.getPublicMethods(clazz, (Method method) -> false == excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StringUtils.isBlank(methodName)) {
            return null;
        }
        return ReflectUtils.getMethod(obj.getClass(), methodName, ClassUtils.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtils.getMethods(clazz);
        if (ArrayUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringUtils.equals(methodName, method.getName(), ignoreCase) || !ClassUtils.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || method.isBridge()) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtils.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtils.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtils.getMethods(clazz);
        if (ArrayUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringUtils.equals(methodName, method.getName(), ignoreCase) || method.isBridge()) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtils.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtils.filter(ReflectUtils.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtils.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        LinkedHashMap<String, Method> result = new LinkedHashMap<String, Method>();
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                result.putIfAbsent(ReflectUtils.getUniqueKey(method), method);
            }
            List<Method> list = ReflectUtils.getDefaultMethodsFromInterface(searchType);
            for (Method method : list) {
                result.putIfAbsent(ReflectUtils.getUniqueKey(method), method);
            }
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.values().toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && ReflectUtils.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && ReflectUtils.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectUtils.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        switch (parameterCount) {
            case 0: {
                return name.startsWith("get") || name.startsWith("is");
            }
            case 1: {
                return name.startsWith("set");
            }
        }
        return false;
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (ArrayUtils.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtils.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new TaraException("Instance class [{}] error!", clazz, e);
            }
        }
        Class<?>[] paramTypes = ClassUtils.getClasses(params);
        Constructor<T> constructor = ReflectUtils.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new TaraException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new TaraException("Instance class [{}] error!", clazz, e);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)ClassUtils.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)ReflectUtils.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = ReflectUtils.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtils.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(ClassUtils.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) {
        return ReflectUtils.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) {
        Class<?>[] types = method.getParameterTypes();
        if (null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtils.getDefaultValue(type);
            }
        }
        try {
            return ReflectUtils.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) {
        ReflectUtils.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassUtils.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = ConvertUtils.convert(parameterTypes[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        if (method.isDefault()) {
            return MethodHandleUtils.invokeSpecial(obj, method, args);
        }
        try {
            return (T)method.invoke(ClassUtils.isStatic(method) ? null : obj, actualArgs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtils.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new TaraException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        try {
            return ReflectUtils.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ModifierUtils.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

