/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.resource;

import com.google.common.collect.Lists;
import com.sondertara.common.lang.resource.Resource;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class MultiResource
implements Resource,
Iterable<Resource>,
Iterator<Resource>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Resource> resources;
    private int cursor;

    public MultiResource(Resource ... resources) {
        this(Lists.newArrayList((Object[])resources));
    }

    public MultiResource(Collection<Resource> resources) {
        this.resources = resources instanceof List ? (List)resources : Lists.newArrayList(resources);
    }

    @Override
    public String getName() {
        return this.resources.get(this.cursor).getName();
    }

    @Override
    public URL getUrl() {
        return this.resources.get(this.cursor).getUrl();
    }

    @Override
    public InputStream getStream() {
        return this.resources.get(this.cursor).getStream();
    }

    @Override
    public boolean isModified() {
        return this.resources.get(this.cursor).isModified();
    }

    @Override
    public String readStr(Charset charset) {
        return this.resources.get(this.cursor).readStr(charset);
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.resources.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.resources.size();
    }

    @Override
    public synchronized Resource next() {
        if (this.cursor >= this.resources.size()) {
            throw new ConcurrentModificationException();
        }
        ++this.cursor;
        return this;
    }

    @Override
    public void remove() {
        this.resources.remove(this.cursor);
    }

    public synchronized void reset() {
        this.cursor = 0;
    }

    public MultiResource add(Resource resource) {
        this.resources.add(resource);
        return this;
    }
}

