/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.resource;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.io.FileUtils;
import com.sondertara.common.lang.resource.Resource;
import com.sondertara.common.util.ObjectUtils;
import com.sondertara.common.util.URLUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL url;
    private long lastModified = 0L;
    protected String name;

    public UrlResource(URI uri) {
        this(URLUtils.url(uri), null);
    }

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        if (null != url && "file".equals(url.getProtocol())) {
            this.lastModified = FileUtils.file(url).lastModified();
        }
        this.name = ObjectUtils.defaultIfNull(name, () -> null != url ? FileUtils.getName(url.getPath()) : null);
    }

    @Deprecated
    public UrlResource(File file) {
        this.url = URLUtils.getURL(file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() {
        if (null == this.url) {
            throw new TaraException("Resource URL is null!", new Object[0]);
        }
        return URLUtils.getStream(this.url);
    }

    @Override
    public boolean isModified() {
        return 0L != this.lastModified && this.lastModified != this.getFile().lastModified();
    }

    public File getFile() {
        return FileUtils.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

