/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.unit;

import com.sondertara.common.lang.unit.DataSize;
import com.sondertara.common.lang.unit.DataUnits;
import java.text.DecimalFormat;

public class DataSizeUtils {
    public static long parse(String text) {
        return DataSize.parse(text).toBytes();
    }

    public static String format(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = Math.min(DataUnits.UNIT_NAMES.length - 1, (int)(Math.log10(size) / Math.log10(1024.0)));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + DataUnits.UNIT_NAMES[digitGroups];
    }
}

