/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.lang.unit;

import com.sondertara.common.lang.unit.DataSize;
import com.sondertara.common.util.StringUtils;

public enum DataUnits {
    BYTES("B", DataSize.ofBytes(1L)),
    KILOBYTES("KB", DataSize.ofKilobytes(1L)),
    MEGABYTES("MB", DataSize.ofMegabytes(1L)),
    GIGABYTES("GB", DataSize.ofGigabytes(1L)),
    TERABYTES("TB", DataSize.ofTerabytes(1L));

    public static final String[] UNIT_NAMES;
    private final String suffix;
    private final DataSize size;

    private DataUnits(String suffix, DataSize size) {
        this.suffix = suffix;
        this.size = size;
    }

    DataSize size() {
        return this.size;
    }

    public static DataUnits fromSuffix(String suffix) {
        for (DataUnits candidate : DataUnits.values()) {
            if (!StringUtils.startWithIgnoreCase(candidate.suffix, suffix)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unknown data unit suffix '" + suffix + "'");
    }

    static {
        UNIT_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    }
}

