/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageResult<T>
implements Serializable {
    private Integer page;
    private Integer pageSize;
    private Long total;
    private List<T> data;

    private PageResult(List<T> data) {
        this.data = null == data ? new ArrayList<T>() : data;
    }

    public PageResult(List<T> data, Long total, Integer page, Integer pageSize) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.data = data;
    }

    public static <T> PageResult<T> of(List<T> data) {
        return new PageResult<T>(data);
    }

    public PageResult<T> pagination(Integer page, Integer pageSize) {
        this.page = page;
        this.pageSize = pageSize;
        return this;
    }

    public PageResult<T> total(Long total) {
        this.total = total;
        return this;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int endIndex() {
        return (int)Math.ceil((float)this.total.longValue() * 1.0f / (float)this.pageSize.intValue()) - 1;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", data=" + this.getData() + ")";
    }
}

