/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.model;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultDTO<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ResultDTO.class);
    private Boolean success;
    private String code;
    private String msg;
    private T data;

    public static <T> ResultDTO<T> success(T data) {
        ResultDTO<T> r = new ResultDTO<T>();
        r.setData(data);
        r.setSuccess(true);
        r.setCode("200");
        r.setMsg("success");
        return r;
    }

    public static <T> ResultDTO<T> success() {
        ResultDTO<T> r = new ResultDTO<T>();
        r.setData(null);
        r.setSuccess(true);
        r.setCode("200");
        r.setMsg("success");
        return r;
    }

    public static <T> ResultDTO<T> success(String code, String msg) {
        ResultDTO<T> result = new ResultDTO<T>();
        result.setSuccess(true);
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> ResultDTO<T> fail(String code, String msg) {
        ResultDTO<T> result = new ResultDTO<T>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> ResultDTO<T> fail(String msg) {
        ResultDTO<T> result = new ResultDTO<T>();
        result.setSuccess(false);
        result.setCode("400");
        result.setMsg(msg);
        return result;
    }

    public void ifSuccess(Consumer<T> consumer) {
        if (this.getSuccess().booleanValue()) {
            consumer.accept(this.data);
        }
    }

    public void ifFailure(Consumer<T> consumer) {
        if (!this.getSuccess().booleanValue()) {
            consumer.accept(this.data);
        }
    }

    public T orElse(T other) {
        return this.success != false ? this.data : other;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.success.booleanValue()) {
            return this.data;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <R> R map(Function<T, R> mapper) {
        if (!this.getSuccess().booleanValue()) {
            log.error("Not Success:{}", (Object)this.msg);
            return null;
        }
        return mapper.apply(this.data);
    }

    public void handleSuccess(Consumer<T> consumer) {
        if (this.getSuccess().booleanValue()) {
            consumer.accept(this.data);
        }
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue});
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultDTO)) {
            return false;
        }
        ResultDTO other = (ResultDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultDTO(success=" + this.getSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

