/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.time;

import com.sondertara.common.time.DateField;
import com.sondertara.common.time.DateModifier;
import com.sondertara.common.time.DateTime;
import com.sondertara.common.util.CompareUtils;
import com.sondertara.common.util.ObjectUtils;
import com.sondertara.common.util.StringUtils;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateFormat;

public class CalendarUtils {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return CalendarUtils.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        return CalendarUtils.calendar(millis, TimeZone.getDefault());
    }

    public static Calendar calendar(long millis, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static Calendar truncate(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.TRUNCATE);
    }

    public static Calendar round(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.ROUND);
    }

    public static Calendar ceiling(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.CEILING);
    }

    public static Calendar ceiling(Calendar calendar, DateField dateField, boolean truncateMillisecond) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.CEILING, truncateMillisecond);
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.SECOND);
    }

    public static Calendar beginOfHour(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.HOUR_OF_DAY);
    }

    public static Calendar endOfHour(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.HOUR_OF_DAY);
    }

    public static Calendar beginOfMinute(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.MINUTE);
    }

    public static Calendar endOfMinute(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.MINUTE);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return CalendarUtils.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return CalendarUtils.truncate(calendar, DateField.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return CalendarUtils.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return CalendarUtils.ceiling(calendar, DateField.WEEK_OF_MONTH);
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.MONTH);
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return CalendarUtils.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(DateField.MONTH.getValue()) / 3 * 3 + 2;
        Calendar resultCal = Calendar.getInstance(calendar.getTimeZone());
        resultCal.set(year, month, CalendarUtils.getLastDayOfMonth(Month.of(month), CalendarUtils.isLeapYear(year)));
        return CalendarUtils.endOfDay(resultCal);
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int getLastDayOfMonth(Month month, boolean isLeapYear) {
        switch (month) {
            case FEBRUARY: {
                return isLeapYear ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return CalendarUtils.truncate(calendar, DateField.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return CalendarUtils.ceiling(calendar, DateField.YEAR);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static boolean isSameWeek(Calendar cal1, Calendar cal2, boolean isMon) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        cal1 = (Calendar)cal1.clone();
        cal2 = (Calendar)cal2.clone();
        if (isMon) {
            cal1.setFirstDayOfWeek(2);
            cal1.set(7, 2);
            cal2.setFirstDayOfWeek(2);
            cal2.set(7, 2);
        } else {
            cal1.setFirstDayOfWeek(1);
            cal1.set(7, 1);
            cal2.setFirstDayOfWeek(1);
            cal2.set(7, 1);
        }
        return CalendarUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameInstant(Calendar date1, Calendar date2) {
        if (null == date1) {
            return null == date2;
        }
        if (null == date2) {
            return false;
        }
        return date1.getTimeInMillis() == date2.getTimeInMillis();
    }

    public static LinkedHashSet<String> yearAndQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = CalendarUtils.calendar(startDate);
        while (startDate <= endDate) {
            quarters.add(CalendarUtils.yearAndQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static String yearAndQuarter(Calendar cal) {
        return StringUtils.builder().append(cal.get(1)).append(cal.get(2) / 3 + 1).toString();
    }

    public static int getBeginValue(Calendar calendar, DateField dateField) {
        return CalendarUtils.getBeginValue(calendar, dateField.getValue());
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, DateField dateField) {
        return CalendarUtils.getEndValue(calendar, dateField.getValue());
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static int compare(Calendar calendar1, Calendar calendar2) {
        return CompareUtils.compare(calendar1, calendar2);
    }

    public static int age(Calendar birthday, Calendar dateToCompare) {
        return CalendarUtils.age(birthday.getTimeInMillis(), dateToCompare.getTimeInMillis());
    }

    protected static int age(long birthday, long dateToCompare) {
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTimeInMillis(birthday);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = cal.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static Calendar parseByPatterns(String str, String ... parsePatterns) {
        return CalendarUtils.parseByPatterns(str, null, parsePatterns);
    }

    public static Calendar parseByPatterns(String str, Locale locale, String ... parsePatterns) {
        return CalendarUtils.parseByPatterns(str, locale, true, parsePatterns);
    }

    public static Calendar parseByPatterns(String str, Locale locale, boolean lenient, String ... parsePatterns) {
        if (str == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        if (parsePatterns.length == 0) {
            parsePatterns = new String[]{"yyyy-MM-dd HH:mm:ss"};
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectUtils.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            FastDateFormat format = FastDateFormat.getInstance((String)parsePattern, (TimeZone)tz, (Locale)lcl);
            calendar.clear();
            try {
                if (format.parse(str, pos, calendar) && pos.getIndex() == str.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new IllegalStateException("Invalid date format: " + str);
    }

    public static Calendar parse(CharSequence str, boolean lenient, DateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(StringUtils.str(str), new ParsePosition(0), calendar) ? calendar : null;
    }
}

