/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.time;

import com.sondertara.common.lang.Assert;
import com.sondertara.common.time.CalendarUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateBetween
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date begin;
    private final Date end;

    public static DateBetween create(Date begin, Date end) {
        return new DateBetween(begin, end);
    }

    public static DateBetween create(Date begin, Date end, boolean isAbs) {
        return new DateBetween(begin, end, isAbs);
    }

    public DateBetween(Date begin, Date end) {
        this(begin, end, true);
    }

    public DateBetween(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public long between(TimeUnit unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / TimeUnit.MILLISECONDS.convert(1L, unit);
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = CalendarUtils.calendar(this.begin);
        Calendar endCal = CalendarUtils.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        Calendar beginCal = CalendarUtils.calendar(this.begin);
        Calendar endCal = CalendarUtils.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (!isReset) {
            if (1 == beginCal.get(2) && 1 == endCal.get(2) && beginCal.get(5) == beginCal.getActualMaximum(5) && endCal.get(5) == endCal.getActualMaximum(5)) {
                beginCal.set(5, 1);
                endCal.set(5, 1);
            }
            endCal.set(1, beginCal.get(1));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }
}

