/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.time;

import com.sondertara.common.time.TemporalUtils;
import com.sondertara.common.util.LocalDateTimeUtils;
import com.sondertara.common.util.StringUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

public class TemporalAccessorUtils
extends TemporalUtils {
    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                return formatter.format(((Instant)time).atZone(ZoneId.systemDefault()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        DateTimeFormatter formatter = StringUtils.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return TemporalAccessorUtils.format(time, formatter);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof Month) {
            return ((Month)temporalAccessor).getValue();
        }
        return TemporalAccessorUtils.toInstant(temporalAccessor).toEpochMilli();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : TemporalAccessorUtils.toInstant(LocalDateTimeUtils.of(temporalAccessor))))))));
        return result;
    }

    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate) {
        long endMills;
        long beginMills;
        long thisMills = TemporalAccessorUtils.toEpochMilli(date);
        return thisMills >= Math.min(beginMills = TemporalAccessorUtils.toEpochMilli(beginDate), endMills = TemporalAccessorUtils.toEpochMilli(endDate)) && thisMills <= Math.max(beginMills, endMills);
    }
}

