/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.bean.copier.BeanCopy;
import com.sondertara.common.bean.copier.BeanToMapCopier;
import com.sondertara.common.bean.copier.MapToBeanCopier;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.reflect.ReflectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    public static void copyNonNullProperties(Object source, Object target) {
        Assert.notNull(source, "Source must not be null", new Object[0]);
        Assert.notNull(target, "Target must not be null", new Object[0]);
        BeanCopy.copyToIgnoreNull(source, target);
    }

    public static void copyProperties(Object source, Object target) {
        Assert.notNull(source, "Source must not be null", new Object[0]);
        Assert.notNull(target, "Target must not be null", new Object[0]);
        BeanCopy.copyTo(source, target);
    }

    public static <T> T beanToBean(Object source, Class<T> target) {
        return BeanCopy.copy(source, target);
    }

    public static <T> List<T> beansToBeans(Collection<?> sourceList, Class<T> targetClass) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        BeanCopy.copy(sourceList, result, targetClass);
        return result;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (bean == null) {
            return map;
        }
        new BeanToMapCopier().copy(bean, map);
        return map;
    }

    public static <T> void mapToBean(Map<?, ?> map, T t) {
        new MapToBeanCopier().copy(map, t);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> clazz) {
        T instance = ReflectUtils.newInstance(clazz, new Object[0]);
        BeanUtils.mapToBean(map, instance);
        return instance;
    }

    public static <T> List<Map<String, Object>> beansToMaps(List<T> list) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (T bean : list) {
            if (bean == null) continue;
            Map<String, Object> beanToMaps = BeanUtils.beanToMap(bean);
            maps.add(beanToMaps);
        }
        return maps;
    }

    public static <T> List<T> mapsToBeans(List<Map<?, Object>> list, Class<T> t) {
        ArrayList<T> beans = new ArrayList<T>();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Map<?, Object> map : list) {
            T t1 = ReflectUtils.newInstance(t, new Object[0]);
            BeanUtils.mapToBean(map, t1);
            beans.add(t1);
        }
        return beans;
    }
}

