/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.Pair;
import com.sondertara.common.lang.loader.JarClassLoader;
import com.sondertara.common.lang.map.WeakConcurrentMap;
import com.sondertara.common.util.StringUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderUtils {
    private static final int PRIMITIVE_MAX_LENGTH = 8;
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new ConcurrentHashMap(32);
    private static final WeakConcurrentMap<Pair<String, ClassLoader>, Class<?>> CLASS_CACHE = new WeakConcurrentMap();

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtils.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtils.class.getClassLoader())) {
            classLoader = ClassLoaderUtils.getSystemClassLoader();
        }
        return classLoader;
    }

    public static URLClassLoader buildURLClassLoader(URL url) {
        try {
            return new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(String name) {
        return ClassLoaderUtils.loadClass(name, true);
    }

    public static Class<?> loadClass(String name, boolean isInitialized) {
        return ClassLoaderUtils.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) {
        Class clazz;
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace('/', '.');
        if (null == classLoader) {
            classLoader = ClassLoaderUtils.getClassLoader();
        }
        if ((clazz = ClassLoaderUtils.loadPrimitiveClass(name)) == null) {
            String finalName = name;
            ClassLoader finalClassLoader = classLoader;
            clazz = CLASS_CACHE.computeIfAbsent(Pair.of(name, classLoader), key -> ClassLoaderUtils.doLoadClass(finalName, finalClassLoader, isInitialized));
        }
        return clazz;
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StringUtils.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassLoaderUtils.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new TaraException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtils.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassLoaderUtils.loadClass(className, classLoader, false);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static Class<?> doLoadClass(String name, ClassLoader classLoader, boolean isInitialized) {
        Class<?> clazz;
        block9: {
            if (name.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = ClassLoaderUtils.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                Class<?> elementClass = ClassLoaderUtils.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = ClassLoaderUtils.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtils.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassLoaderUtils.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block9;
                    throw new TaraException(ex);
                }
            }
        }
        return clazz;
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList<Class> primitiveTypes = new ArrayList<Class>(32);
        primitiveTypes.add(Byte.class);
        primitiveTypes.add(Character.class);
        primitiveTypes.add(Double.class);
        primitiveTypes.add(Float.class);
        primitiveTypes.add(Integer.class);
        primitiveTypes.add(Long.class);
        primitiveTypes.add(Short.class);
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class primitiveType : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(primitiveType.getName(), primitiveType);
        }
    }
}

