/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.util.StringUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HexUtils {
    public static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LOWER_CHARS = "0123456789abcdef".toCharArray();
    private static final char[] UPPER_CHARS = "0123456789ABCDEF".toCharArray();

    public static boolean isHexNumber(String value) {
        int index;
        int n = index = value.startsWith("-") ? 1 : 0;
        if (value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index)) {
            try {
                Long.decode(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, Charset charset) {
        return HexUtils.encodeHex(StringUtils.bytes((CharSequence)str, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        char[] alphabets = toLowerCase ? LOWER_CHARS : UPPER_CHARS;
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = alphabets[(0xF0 & data[i]) >>> 4];
            out[j++] = alphabets[0xF & data[i]];
        }
        return out;
    }

    private static char[] encode(byte[] data, boolean toLowerCase) {
        char[] alphabets = toLowerCase ? LOWER_CHARS : UPPER_CHARS;
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = alphabets[(0xF0 & data[i]) >>> 4];
            out[j++] = alphabets[0xF & data[i]];
        }
        return out;
    }

    public static byte[] decode(CharSequence encoded) {
        if (StringUtils.isEmpty(encoded)) {
            return null;
        }
        int len = (encoded = StringUtils.cleanBlank(encoded)).length();
        if ((len & 1) != 0) {
            encoded = "0" + encoded;
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(encoded.charAt(j), j) << 4;
            f |= HexUtils.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new TaraException("Illegal hexadecimal character {} at index {}", Character.valueOf(ch), index);
        }
        return digit;
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtils.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, Charset charset) {
        return HexUtils.encodeHexStr(StringUtils.bytes((CharSequence)data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return HexUtils.encodeHexStr(data, StandardCharsets.UTF_8);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return new String(HexUtils.encodeHex(data, toLowerCase));
    }

    public static String decodeHexStr(String hexStr) {
        return HexUtils.decodeHexStr(hexStr, StandardCharsets.UTF_8);
    }

    public static String decodeHexStr(String hexStr, Charset charset) {
        if (StringUtils.isEmpty(hexStr)) {
            return hexStr;
        }
        return StringUtils.str(HexUtils.decodeHex(hexStr), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) {
        return StringUtils.str(HexUtils.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtils.decodeHex((CharSequence)hexStr);
    }

    public static byte[] decodeHex(char[] hexData) {
        return HexUtils.decodeHex(String.valueOf(hexData));
    }

    public static byte[] decodeHex(CharSequence hexData) {
        return HexUtils.decode(hexData);
    }

    public static String encodeColor(Color color) {
        return HexUtils.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = HexUtils.toHex(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toHex(int value) {
        return Integer.toHexString(value);
    }

    public static int hexToInt(String value) {
        return Integer.parseInt(value, 16);
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static long hexToLong(String value) {
        return Long.parseLong(value, 16);
    }

    public static BigInteger toBigInteger(String hexStr) {
        if (null == hexStr) {
            return null;
        }
        return new BigInteger(hexStr, 16);
    }

    public static String format(String hexStr) {
        int length = hexStr.length();
        StringBuilder builder = StringUtils.builder(length + length / 2);
        builder.append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return builder.toString();
    }

    public static String string2Unicode(String string) {
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            unicode.append("\\u").append(Integer.toHexString(c));
        }
        return unicode.toString();
    }

    public static String unicodeStrTo16(String s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            str.append(Integer.toHexString(ch));
        }
        return str.toString();
    }

    public static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    public static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
        }
        return bytes;
    }
}

