/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.util.StringUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    private static final String IP_UNKNOWN = "unknown";
    private static Map<String, List<InetAddress>> LOCAL_ADDRESS_MAP = IpUtils.getLocalAddresses();

    public static String getIpAddr(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.contains(",")) {
            String[] ipList;
            for (String s : ipList = ip.split(",")) {
                String tmp = s;
                if (tmp == null || IP_UNKNOWN.equalsIgnoreCase(tmp.trim())) continue;
                return tmp.trim();
            }
        }
        return ip;
    }

    public static String getLocalHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFullyLocalHostName() {
        String hostName = null;
        try {
            InetAddress inet = InetAddress.getLocalHost();
            hostName = inet.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostName;
    }

    public static String getLocalHostAddress() {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            return inet.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<InetAddress>> getLocalAddresses() {
        if (LOCAL_ADDRESS_MAP != null) {
            return LOCAL_ADDRESS_MAP;
        }
        LinkedHashMap<String, List<InetAddress>> map = new LinkedHashMap<String, List<InetAddress>>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces != null && interfaces.hasMoreElements()) {
                ArrayList<InetAddress> tmpList = new ArrayList<InetAddress>();
                NetworkInterface interfaceN = interfaces.nextElement();
                Enumeration<InetAddress> ienum = interfaceN.getInetAddresses();
                while (ienum.hasMoreElements()) {
                    InetAddress ia = ienum.nextElement();
                    tmpList.add(ia);
                }
                map.put(interfaceN.getName(), tmpList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getLocalIp() {
        return IpUtils.getLocalIPV4(false);
    }

    public static String getLocalIPV4(boolean isInter) {
        Map<String, List<InetAddress>> map = IpUtils.getLocalAddresses();
        ArrayList list = new ArrayList();
        map.values().forEach(list::addAll);
        String localIp = "";
        for (InetAddress ia : list) {
            String ip = ia.getHostAddress();
            if (ia instanceof Inet6Address || ip.startsWith("127")) continue;
            if (StringUtils.isBlank(localIp)) {
                localIp = ip;
            }
            if (isInter && ip.startsWith("19.")) {
                return ip;
            }
            if (isInter || ip.startsWith("19.")) continue;
            return ip;
        }
        return localIp;
    }

    public static boolean isDomainEqualsLocal(String domainName) {
        if (StringUtils.isBlank(domainName)) {
            return false;
        }
        try {
            InetAddress host = InetAddress.getByName(domainName);
            String domainAddress = host.getHostAddress();
            return domainAddress.equals(IpUtils.getLocalHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }
}

