/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.regex.PatternPool;
import com.sondertara.common.time.CalendarUtils;
import com.sondertara.common.time.DateBetween;
import com.sondertara.common.time.DateField;
import com.sondertara.common.time.DatePattern;
import com.sondertara.common.time.DateTime;
import com.sondertara.common.time.Quarter;
import com.sondertara.common.time.TemporalAccessorUtils;
import com.sondertara.common.time.TemporalUtils;
import com.sondertara.common.time.Week;
import com.sondertara.common.time.Zodiac;
import com.sondertara.common.util.CompareUtils;
import com.sondertara.common.util.ErrorUtils;
import com.sondertara.common.util.ObjectUtils;
import com.sondertara.common.util.RegexUtils;
import com.sondertara.common.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Period;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.DatePrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeUtils
extends CalendarUtils {
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeUtils.class);
    public static final String DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_MILLS_FORMATTER = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMATTER = "yyyy-MM-dd";
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final String[] FREQUENTLY_USED_UTC_WITH_Z_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
    private static final String[] FREQUENTLY_USED_NUMBER_DATE_FORMATS = new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmmssSSS", "yyyyMMdd", "yyyyMMss", "HHmmss"};
    private static final String[] FREQUENTLY_USED_CST_DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss zzz yyyy"};
    private static final String[] FREQUENTLY_USED_DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "HH:mm:ss", "HH\u65f6mm\u5206ss\u79d2", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss.SSS"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return LocalDateTimeUtils.beginOfSecond(LocalDateTimeUtils.date());
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return LocalDateTimeUtils.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int weekOfYear(Date date) {
        LocalDateTime localDateTime = LocalDateTimeUtils.parseLocalDateTime(date);
        TemporalField temporalField = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        return localDateTime.get(temporalField);
    }

    public static int weekOfMonth(Date date) {
        LocalDateTime localDateTime = LocalDateTimeUtils.parseLocalDateTime(date);
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        TemporalField temporalField = weekFields.weekOfMonth();
        return localDateTime.get(temporalField);
    }

    public static LocalDateTime parseLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate parseLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static boolean isWeekend(Date date) {
        LocalDateTime localDateTime = LocalDateTimeUtils.parseLocalDateTime(date);
        return localDateTime.query(temporal -> temporal.get(ChronoField.DAY_OF_WEEK) > 5);
    }

    public static int thisWeekOfYear() {
        return LocalDateTimeUtils.weekOfYear(LocalDateTimeUtils.date());
    }

    public static int thisWeekOfMonth() {
        return LocalDateTimeUtils.weekOfMonth(LocalDateTimeUtils.date());
    }

    public static String yearAndQuarter(Date date) {
        return LocalDateTimeUtils.yearAndQuarter(LocalDateTimeUtils.calendar(date));
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return LocalDateTimeUtils.yearAndQuarter(startDate.getTime(), endDate.getTime());
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return TemporalAccessorUtils.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, DateParser parser, boolean lenient) {
        return new DateTime(dateStr, parser, lenient);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        return new DateTime(dateStr, LocalDateTimeUtils.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String str, String ... parsePatterns) {
        return new DateTime(CalendarUtils.parseByPatterns(str, parsePatterns));
    }

    public static DateTime parseTimeToday(String timeString) {
        timeString = StringUtils.format("{} {}", LocalDateTimeUtils.today(), timeString);
        if (1 == StringUtils.count((CharSequence)timeString, ':')) {
            return LocalDateTimeUtils.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return LocalDateTimeUtils.parse((CharSequence)timeString, (DateParser)DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StringUtils.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (StringUtils.contains((CharSequence)utcString, '+')) {
                String zoneOffset = StringUtils.subAfter((CharSequence)(utcString = utcString.replace(" +", "+")), '+', true);
                if (StringUtils.isBlank(zoneOffset)) {
                    throw ErrorUtils.illegalArgumentException("Invalid format: [{}]", utcString);
                }
                if (!StringUtils.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StringUtils.subBefore((CharSequence)utcString, '+', true);
                    utcString = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (StringUtils.contains((CharSequence)utcString, '.')) {
                    return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (StringUtils.contains((CharSequence)utcString, '.')) {
                return LocalDateTimeUtils.parse((CharSequence)utcString, (DateParser)DatePattern.UTC_SIMPLE_MS_FORMAT);
            }
        }
        throw ErrorUtils.illegalStateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return LocalDateTimeUtils.parse(cstString, (DateParser)DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parseDate(CharSequence dateCharSequence) {
        if (StringUtils.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StringUtils.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (NumberUtils.isCreatable((String)dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (RegexUtils.isMatch(PatternPool.TIME, (CharSequence)dateStr)) {
                return LocalDateTimeUtils.parseTimeToday(dateStr);
            }
            if (StringUtils.containsAnyIgnoreCase(dateStr, wtb)) {
                return LocalDateTimeUtils.parseCST(dateStr);
            }
            if (StringUtils.contains((CharSequence)dateStr, 'T')) {
                return LocalDateTimeUtils.parseUTC(dateStr);
            }
        }
        if (RegexUtils.isMatch(DatePattern.REGEX_NORM, (CharSequence)(dateStr = LocalDateTimeUtils.normalize(dateStr)))) {
            int colonCount = StringUtils.count((CharSequence)dateStr, ':');
            switch (colonCount) {
                case 0: {
                    return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = StringUtils.indexOf(dateStr, '.');
                    if (indexOfDot > 0) {
                        int length1 = dateStr.length();
                        if (length1 - indexOfDot > 4) {
                            dateStr = StringUtils.subPre(dateStr, indexOfDot + 4);
                        }
                        return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return LocalDateTimeUtils.parse((CharSequence)dateStr, (DateParser)DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw ErrorUtils.illegalStateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime truncate(Date date, DateField dateField) {
        return new DateTime(LocalDateTimeUtils.truncate(LocalDateTimeUtils.calendar(date), dateField));
    }

    public static DateTime round(Date date, DateField dateField) {
        return new DateTime(LocalDateTimeUtils.round(LocalDateTimeUtils.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField) {
        return new DateTime(LocalDateTimeUtils.ceiling(LocalDateTimeUtils.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField, boolean truncateMillisecond) {
        return new DateTime(LocalDateTimeUtils.ceiling(LocalDateTimeUtils.calendar(date), dateField, truncateMillisecond));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfSecond(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfSecond(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfHour(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfHour(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfHour(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfHour(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfMinute(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfMinute(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfMinute(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfMinute(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfDay(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfDay(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfWeek(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date, boolean isMondayAsFirstDay) {
        return new DateTime(LocalDateTimeUtils.beginOfWeek(LocalDateTimeUtils.calendar(date), isMondayAsFirstDay));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfWeek(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfWeek(Date date, boolean isSundayAsLastDay) {
        return new DateTime(LocalDateTimeUtils.endOfWeek(LocalDateTimeUtils.calendar(date), isSundayAsLastDay));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfMonth(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfMonth(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfQuarter(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfQuarter(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(LocalDateTimeUtils.beginOfYear(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(LocalDateTimeUtils.endOfYear(LocalDateTimeUtils.calendar(date)));
    }

    public static DateTime yesterday() {
        return LocalDateTimeUtils.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return LocalDateTimeUtils.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return LocalDateTimeUtils.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return LocalDateTimeUtils.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return LocalDateTimeUtils.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return LocalDateTimeUtils.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return LocalDateTimeUtils.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return LocalDateTimeUtils.dateNew(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, TimeUnit unit) {
        return LocalDateTimeUtils.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, TimeUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(TimeUnit.MILLISECONDS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = LocalDateTimeUtils.beginOfDay(beginDate);
            endDate = LocalDateTimeUtils.beginOfDay(endDate);
        }
        return LocalDateTimeUtils.between(beginDate, endDate, TimeUnit.DAYS);
    }

    public static long betweenWeek(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = LocalDateTimeUtils.beginOfDay(beginDate);
            endDate = LocalDateTimeUtils.beginOfDay(endDate);
        }
        return LocalDateTimeUtils.between(beginDate, endDate, TimeUnit.DAYS) / 7L;
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtils.isSameDay(LocalDateTimeUtils.calendar(date1), LocalDateTimeUtils.calendar(date2));
    }

    public static boolean isSameWeek(Date date1, Date date2, boolean isMon) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtils.isSameWeek(LocalDateTimeUtils.calendar(date1), LocalDateTimeUtils.calendar(date2), isMon);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtils.isSameMonth(LocalDateTimeUtils.calendar(date1), LocalDateTimeUtils.calendar(date2));
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int ageOfNow(String birthDay) {
        return LocalDateTimeUtils.ageOfNow(LocalDateTimeUtils.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return LocalDateTimeUtils.age(birthDay, LocalDateTimeUtils.date());
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = LocalDateTimeUtils.date();
        }
        return LocalDateTimeUtils.age(birthday.getTime(), dateToCompare.getTime());
    }

    public static int timeToSecond(String timeStr) {
        if (StringUtils.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StringUtils.splitTrim((CharSequence)timeStr, ":", 3);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtils.compare(date1, date2);
    }

    public static int compare(Date date1, Date date2, String format) {
        if (format != null) {
            if (date1 != null) {
                date1 = LocalDateTimeUtils.parse(LocalDateTimeUtils.format(date1, format), format);
            }
            if (date2 != null) {
                date2 = LocalDateTimeUtils.parse(LocalDateTimeUtils.format(date2, format), format);
            }
        }
        return CompareUtils.compare(date1, date2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtils.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTimeUtils.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTimeUtils.of(date);
    }

    public static DateTime convertTimeZone(Date date, ZoneId zoneId) {
        return new DateTime(date, TimeZone.getTimeZone(zoneId));
    }

    public static DateTime convertTimeZone(Date date, TimeZone timeZone) {
        return new DateTime(date, timeZone);
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int lengthOfMonth(int month, boolean isLeapYear) {
        return Month.of(month).length(isLeapYear);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return LocalDateTimeUtils.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShotName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    public static boolean isOverlap(Date realStartTime, Date realEndTime, Date startTime, Date endTime) {
        return startTime.before(realEndTime) && endTime.after(realStartTime);
    }

    private static String normalize(CharSequence dateStr) {
        if (StringUtils.isBlank(dateStr)) {
            return StringUtils.str(dateStr);
        }
        List<String> dateAndTime = StringUtils.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringUtils.str(dateStr);
        }
        StringBuilder builder = StringUtils.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringUtils.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringUtils.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }

    public static Date random(Date startDateInclusive, Date endDateExclusive) {
        int betweenSeconds = (int)((endDateExclusive.getTime() - startDateInclusive.getTime()) / 1000L);
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDateInclusive);
        instance.add(13, RandomUtils.nextInt((int)0, (int)betweenSeconds));
        return instance.getTime();
    }

    public static Date random() {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(0L);
        instance.add(12, RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE));
        return instance.getTime();
    }

    public static Date getYesterday(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        localDateTime = localDateTime.minusDays(1L);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getYesterday() {
        return LocalDateTimeUtils.getYesterday(Calendar.getInstance().getTime());
    }

    public static Date getTomorrow(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        localDateTime = localDateTime.plusDays(1L);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getTomorrow() {
        LocalDateTime localDateTime = LocalDateTime.now().plusDays(1L);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean isDayBetween(Date date, Date startDateInclusive, Date endDateInclusive) {
        if (date == null) {
            return false;
        }
        return date.after(startDateInclusive) && date.before(endDateInclusive) || date.equals(startDateInclusive) || date.equals(endDateInclusive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalDateTime parseLocalDateTime(String dateTimeStr) {
        String[] dateFormats;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dateTimeStr)) {
            throw new IllegalArgumentException("Date string must not be null");
        }
        if (NumberUtils.isCreatable((String)dateTimeStr)) {
            dateFormats = FREQUENTLY_USED_NUMBER_DATE_FORMATS;
        } else if (org.apache.commons.lang3.StringUtils.contains((CharSequence)dateTimeStr, (int)84)) {
            String utcString = dateTimeStr;
            int length = utcString.length();
            if (org.apache.commons.lang3.StringUtils.contains((CharSequence)utcString, (int)90)) {
                dateFormats = FREQUENTLY_USED_UTC_WITH_Z_DATE_FORMATS;
            } else if (org.apache.commons.lang3.StringUtils.contains((CharSequence)utcString, (int)43)) {
                String zoneOffset = org.apache.commons.lang3.StringUtils.substringAfterLast((String)(utcString = utcString.replace(" +", "+")), (int)43);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)zoneOffset)) {
                    throw new TaraException("Invalid UTC format: [{}]", dateTimeStr);
                }
                dateFormats = new String[]{DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT.getPattern(), DatePattern.UTC_WITH_XXX_OFFSET_FORMAT.getPattern()};
            } else if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                dateFormats = new String[]{DatePattern.UTC_SIMPLE_FORMAT.getPattern()};
            } else {
                if (!org.apache.commons.lang3.StringUtils.contains((CharSequence)utcString, (int)46)) throw new TaraException("Invalid UTC format: [{}]", dateTimeStr);
                dateFormats = new String[]{DatePattern.UTC_SIMPLE_MS_FORMAT.getPattern()};
            }
        } else if (org.apache.commons.lang3.StringUtils.containsAny((CharSequence)dateTimeStr, (CharSequence[])wtb)) {
            dateFormats = FREQUENTLY_USED_CST_DATE_FORMATS;
        } else {
            dateTimeStr = LocalDateTimeUtils.normalize(dateTimeStr);
            dateFormats = FREQUENTLY_USED_DATE_FORMATS;
        }
        for (String dateFormat : dateFormats) {
            try {
                return LocalDateTimeUtils.parseLocalDateTime((CharSequence)dateTimeStr, DateTimeFormatter.ofPattern(dateFormat));
            }
            catch (Exception e) {
                log.debug("Error parsing date format: " + dateFormat, (Throwable)e);
            }
        }
        throw new IllegalStateException("Invalid date format: " + dateTimeStr);
    }

    public static Date eraseTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        LocalDateTimeUtils.eraseTime(calendar);
        return calendar.getTime();
    }

    public static Date eraseTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getGapTime(long timeLength, TimeUnit timeUnit) {
        long seconds;
        long minutes;
        long hours;
        String separator = ":";
        StringBuilder gapTime = new StringBuilder();
        long days = timeUnit.toDays(timeLength);
        if (days > 0L) {
            gapTime.append(org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(days % 365L), (int)2, (String)"0"));
            gapTime.append(separator);
        }
        if ((hours = timeUnit.toHours(timeLength)) > 0L) {
            gapTime.append(org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(hours % 24L), (int)2, (String)"0"));
            gapTime.append(separator);
        }
        if ((minutes = timeUnit.toMinutes(timeLength)) > 0L) {
            gapTime.append(org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(minutes % 60L), (int)2, (String)"0"));
            gapTime.append(separator);
        }
        if ((seconds = timeUnit.toSeconds(timeLength)) > 0L) {
            gapTime.append(org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(seconds % 60L), (int)2, (String)"0"));
        }
        return gapTime.toString();
    }

    public static String getNow() {
        return LocalDateTimeUtils.now(DATE_TIME_FORMATTER);
    }

    public static String now() {
        return LocalDateTimeUtils.getNow();
    }

    public static String today() {
        return LocalDateTimeUtils.now(DATE_FORMATTER);
    }

    public static String now(String formatPattern) {
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        return dateTime.format(formatter);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr, String formatPattern) {
        try {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dateTimeStr)) {
                return null;
            }
            DateTimeFormatter formatter = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formatPattern)) {
                if (StringUtils.startWith((CharSequence)formatPattern, "yyyyMMddHHmmss")) {
                    String fraction = StringUtils.removePrefix(formatPattern, "yyyyMMddHHmmss");
                    if (RegexUtils.isMatch("[S]{1,2}", fraction).booleanValue()) {
                        formatPattern = formatPattern + org.apache.commons.lang3.StringUtils.repeat((char)'0', (int)(3 - fraction.length()));
                    }
                    formatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
                } else {
                    formatter = DateTimeFormatter.ofPattern(formatPattern);
                }
            }
            return LocalDateTimeUtils.parseLocalDateTime((CharSequence)dateTimeStr, formatter);
        }
        catch (Exception e) {
            log.error("parser date error,params=[{}],pattern=[{}]", new Object[]{dateTimeStr, formatPattern, e});
            return null;
        }
    }

    private static LocalDate parseLocalDate(String date) {
        for (String formatter : DatePattern.GENERIC_DATE_FORMATTERS) {
            LocalDate localDate = LocalDateTimeUtils.parseLocalDate((CharSequence)date, formatter);
            if (null == localDate) continue;
            return localDate;
        }
        throw new IllegalArgumentException("Invalid date format: " + date);
    }

    public static String format(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        Instant instant = null;
        try {
            instant = date.toInstant();
        }
        catch (Exception e) {
            instant = Instant.ofEpochMilli(date.getTime());
        }
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }

    public static String format(Date date) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtils.format(date, DATE_TIME_FORMATTER);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        if (null == localDateTime) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            return localDateTime.format(formatter);
        }
        catch (Exception e) {
            log.error("parser date str error,pattern=[{}]", (Object)pattern, (Object)e);
            return null;
        }
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        if (null == localDate) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return LocalDateTimeUtils.formatLocalDateTime(localDateTime, DATE_TIME_FORMATTER);
    }

    public static DateTime parse(String dateTime) {
        return LocalDateTimeUtils.parse(dateTime, DATE_TIME_FORMATTER);
    }

    public static DateTime parse(String dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        Date date = null;
        try {
            LocalDateTime localDateTime = LocalDateTimeUtils.parseLocalDateTime(dateTime, pattern);
            assert (localDateTime != null);
            date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (Exception localDateTime) {
            // empty catch block
        }
        if (date == null) {
            try {
                LocalDate parse = LocalDateTimeUtils.parseLocalDate(dateTime);
                date = Date.from(parse.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DateTime(date);
    }

    public static int getDayDelay(String startDate, String endDate) {
        LocalDate start = LocalDateTimeUtils.parseLocalDate(startDate);
        LocalDate end = LocalDateTimeUtils.parseLocalDate(endDate);
        if (start != null && end != null) {
            long l = end.toEpochDay() - start.toEpochDay();
            return (int)l;
        }
        return -1;
    }

    public static String getDayStart(String dateStr) {
        LocalDate localDate = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
        return LocalDateTimeUtils.getDayStart(localDate);
    }

    public static String getDayStart(LocalDate localDate) {
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static String getDayEnd(String dateStr) {
        LocalDate localDate = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
        return LocalDateTimeUtils.getDayEnd(localDate);
    }

    public static String getDayEnd(LocalDate localDate) {
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static Long getTimeStamp(String timeStr, String formatter) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(formatter));
            return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                LocalDate localDate = LocalDate.parse(timeStr, DateTimeFormatter.ofPattern(formatter));
                return localDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli();
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
                return null;
            }
        }
    }

    public static Long getTimeStamp(String timeStr) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(DATE_TIME_MILLS_FORMATTER));
            return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception localDateTime) {
            try {
                LocalDateTime localDateTime2 = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(DATE_TIME_FORMATTER));
                return localDateTime2.toInstant(ZoneOffset.of("+8")).toEpochMilli();
            }
            catch (Exception localDateTime2) {
                try {
                    LocalDate localDate = LocalDate.parse(timeStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
                    return localDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public static LocalDateTime getLocalDateTime(long timestamp) {
        try {
            return Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.of("+8")).toLocalDateTime();
        }
        catch (Exception exception) {
            try {
                return Instant.ofEpochSecond(timestamp).atZone(ZoneOffset.of("+8")).toLocalDateTime();
            }
            catch (Exception exception2) {
                throw new RuntimeException("timestamp is invalid:" + timestamp);
            }
        }
    }

    public static LocalDate getLocalDate(long timestamp) {
        try {
            return Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.of("+8")).toLocalDate();
        }
        catch (Exception exception) {
            try {
                return Instant.ofEpochSecond(timestamp).atZone(ZoneOffset.of("+8")).toLocalDate();
            }
            catch (Exception exception2) {
                throw new RuntimeException("timestamp is invalid:" + timestamp);
            }
        }
    }

    public static String getDateTimeSecondStr(long timestamp) {
        LocalDateTime localDateTime = LocalDateTimeUtils.getLocalDateTime(timestamp);
        if (null != localDateTime) {
            return localDateTime.format(DateTimeFormatter.ofPattern(DATE_TIME_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }

    public static String getDateTimeMillsStr(long timestamp) {
        LocalDateTime localDateTime = LocalDateTimeUtils.getLocalDateTime(timestamp);
        if (null != localDateTime) {
            localDateTime.format(DateTimeFormatter.ofPattern(DATE_TIME_MILLS_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }

    public static String getDateStr(long timestamp) {
        LocalDate localDate = LocalDateTimeUtils.getLocalDate(timestamp);
        if (null != localDate) {
            localDate.format(DateTimeFormatter.ofPattern(DATE_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }

    public static LocalDateTime of(Instant instant) {
        return LocalDateTimeUtils.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return LocalDateTimeUtils.of(instant, ZoneId.of("UTC"));
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ObjectUtils.defaultIfNull(zoneId, ZoneId::systemDefault));
    }

    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        if (null == instant) {
            return null;
        }
        return LocalDateTimeUtils.of(instant, ObjectUtils.defaultIfNull(timeZone, TimeZone::getDefault).toZoneId());
    }

    public static LocalDateTime of(long epochMilli) {
        return LocalDateTimeUtils.of(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime ofUTC(long epochMilli) {
        return LocalDateTimeUtils.ofUTC(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime of(long epochMilli, ZoneId zoneId) {
        return LocalDateTimeUtils.of(Instant.ofEpochMilli(epochMilli), zoneId);
    }

    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        return LocalDateTimeUtils.of(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        if (date instanceof DateTime) {
            return LocalDateTimeUtils.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return LocalDateTimeUtils.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporalAccessor, ZoneId.systemDefault());
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        return LocalDateTime.of(TemporalAccessorUtils.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtils.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTimeUtils.of(temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtils.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parseLocalDateTime(CharSequence text, DateTimeFormatter formatter) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(text);
        }
        return LocalDateTimeUtils.of(formatter.parse(text));
    }

    public static LocalDate parseLocalDate(CharSequence text) {
        return LocalDateTimeUtils.parseLocalDate(text, (DateTimeFormatter)null);
    }

    public static LocalDate parseLocalDate(CharSequence text, DateTimeFormatter formatter) {
        if (null == text) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(text);
        }
        return LocalDateTimeUtils.ofDate(formatter.parse(text));
    }

    public static LocalDate parseLocalDate(CharSequence text, String format) {
        if (null == text) {
            return null;
        }
        return LocalDateTimeUtils.parseLocalDate(text, DateTimeFormatter.ofPattern(format));
    }

    public static String formatNormal(LocalDateTime time) {
        return LocalDateTimeUtils.format(time, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime time, DateTimeFormatter formatter) {
        return TemporalAccessorUtils.format((TemporalAccessor)time, formatter);
    }

    public static String format(LocalDateTime time, String format) {
        return TemporalAccessorUtils.format((TemporalAccessor)time, format);
    }

    public static String formatNormal(LocalDate date) {
        return LocalDateTimeUtils.format(date, DatePattern.NORM_DATE_FORMATTER);
    }

    public static String format(LocalDate date, DateTimeFormatter formatter) {
        return TemporalAccessorUtils.format((TemporalAccessor)date, formatter);
    }

    public static String format(LocalDate date, String format) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtils.format(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        return TemporalUtils.offset(time, number, field);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return TemporalUtils.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        return TemporalUtils.between(startTimeInclude, endTimeExclude, unit);
    }

    public static Period betweenPeriod(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return LocalDateTimeUtils.endOfDay(time, false);
    }

    public static LocalDateTime endOfDay(LocalDateTime time, boolean truncateMillisecond) {
        if (truncateMillisecond) {
            return time.with(LocalTime.of(23, 59, 59));
        }
        return time.with(LocalTime.MAX);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtils.toEpochMilli(temporalAccessor);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static Week dayOfWeek(LocalDate localDate) {
        return Week.of(localDate.getDayOfWeek());
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return startTime.isBefore(realEndTime) && endTime.isAfter(realStartTime);
    }

    public static int weekOfYear(TemporalAccessor date) {
        return TemporalAccessorUtils.get(date, WeekFields.ISO.weekOfYear());
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1 != null && date2 != null && LocalDateTimeUtils.isSameDay(date1.toLocalDate(), date2.toLocalDate());
    }

    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static boolean isIn(ChronoLocalDateTime<?> date, ChronoLocalDateTime<?> beginDate, ChronoLocalDateTime<?> endDate) {
        return TemporalAccessorUtils.isIn(date, beginDate, endDate);
    }
}

