/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.reflect.LookupFactory;
import com.sondertara.common.lang.reflect.ReflectUtils;
import com.sondertara.common.util.StringUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;

public class MethodHandleUtils
extends MethodUtils {
    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return LookupFactory.lookup(callerClass);
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, MethodType type) {
        if (StringUtils.isBlank(name)) {
            return MethodHandleUtils.findConstructor(callerClass, type);
        }
        MethodHandle handle = null;
        MethodHandles.Lookup lookup = MethodHandleUtils.lookup(callerClass);
        try {
            handle = lookup.findVirtual(callerClass, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (null == handle) {
            try {
                handle = lookup.findStatic(callerClass, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (null == handle) {
            try {
                handle = lookup.findSpecial(callerClass, name, type, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new TaraException(e);
            }
        }
        return handle;
    }

    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... args) {
        return MethodHandleUtils.findConstructor(callerClass, MethodType.methodType(Void.TYPE, args));
    }

    public static MethodHandle findConstructor(Class<?> callerClass, MethodType type) {
        MethodHandles.Lookup lookup = MethodHandleUtils.lookup(callerClass);
        try {
            return lookup.findConstructor(callerClass, type);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new TaraException(e);
        }
    }

    public static <T> T invokeSpecial(Object obj, String methodName, Object ... args) {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtils.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new TaraException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return MethodHandleUtils.invokeSpecial(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) {
        return MethodHandleUtils.invoke(false, obj, method, args);
    }

    public static <T> T invokeSpecial(Object obj, Method method, Object ... args) {
        return MethodHandleUtils.invoke(true, obj, method, args);
    }

    public static <T> T invoke(boolean isSpecial, Object obj, Method method, Object ... args) {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandleUtils.lookup(declaringClass);
        try {
            MethodHandle handle;
            MethodHandle methodHandle = handle = isSpecial ? lookup.unreflectSpecial(method, declaringClass) : lookup.unreflect(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new TaraException(e);
        }
    }
}

