/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final Map<String, PropertiesUtils> instanceMap = new HashMap<String, PropertiesUtils>();
    private final String propertyFileName;
    private Properties properties = null;
    private URI uri = null;

    private PropertiesUtils(String propertyFileName) {
        this.propertyFileName = propertyFileName;
        this.loadProperties();
    }

    public static Properties fromFile(String file) {
        Properties properties;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(new File(file));
            properties = PropertiesUtils.fromStream(stream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                PropertiesUtils.close(stream);
                throw throwable;
            }
        }
        PropertiesUtils.close(stream);
        return properties;
    }

    public static Properties fromClasspath(String file) {
        Properties properties;
        InputStream stream = null;
        try {
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            properties = PropertiesUtils.fromStream(stream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                PropertiesUtils.close(stream);
                throw throwable;
            }
        }
        PropertiesUtils.close(stream);
        return properties;
    }

    private static Properties fromStream(InputStream stream) throws IOException {
        Properties dest = new Properties();
        Properties src = new Properties();
        src.load(stream);
        for (Map.Entry<Object, Object> entry : src.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newKey = key;
            Object newValue = value;
            if (newKey instanceof String) {
                newKey = key.toString().trim();
            }
            if (newValue instanceof String) {
                newValue = value.toString().trim();
            }
            dest.put(newKey, newValue);
        }
        return dest;
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static PropertiesUtils getInstance(String propertyFileName) {
        if (instanceMap.get(propertyFileName) != null) {
            return instanceMap.get(propertyFileName);
        }
        PropertiesUtils instance = new PropertiesUtils(propertyFileName);
        instanceMap.put(propertyFileName, instance);
        return instance;
    }

    private void loadProperties() {
        try {
            this.properties = new Properties();
            ClassLoader oClassLoader = Thread.currentThread().getContextClassLoader();
            this.uri = oClassLoader.getResource(this.propertyFileName + ".properties").toURI();
            InputStream is = oClassLoader.getResourceAsStream(this.propertyFileName + ".properties");
            if (is != null) {
                this.properties.load(is);
                is.close();
            }
            Object var2_3 = null;
        }
        catch (Exception e) {
            logger.error("can't find properties file[{}]", (Object)this.propertyFileName, (Object)e);
        }
    }

    public String getProperty(String propertyName) {
        String property = null;
        try {
            if (this.properties == null) {
                this.loadProperties();
            }
            property = this.properties.getProperty(propertyName);
        }
        catch (Exception e) {
            logger.error("read property[{}] error. ", (Object)propertyName, (Object)e);
        }
        if (null == property) {
            throw new TaraException("no property[{}] found in[{}] file.", propertyName, this.propertyFileName);
        }
        return property;
    }

    public String getProperty(String propertyName, String defaultValue) {
        try {
            if (this.properties == null) {
                this.loadProperties();
            }
            return this.properties.getProperty(propertyName, defaultValue);
        }
        catch (Exception e) {
            logger.error("read property[{}] error. ", (Object)propertyName, (Object)e);
            return defaultValue;
        }
    }

    public Properties getProperties() throws TaraException {
        try {
            if (this.properties == null) {
                this.loadProperties();
            }
            return this.properties;
        }
        catch (Exception e) {
            logger.error("load property file name[{}] error. ", (Object)this.propertyFileName, (Object)e);
            throw new TaraException(e.getMessage(), new Object[0]);
        }
    }

    public void setProperty(String propertyName, String propertyValue) {
        try {
            if (this.properties == null) {
                this.loadProperties();
            }
            FileOutputStream fos = new FileOutputStream(new File(this.uri));
            this.properties.setProperty(propertyName, propertyValue);
            this.properties.store(fos, "Update '" + propertyName + "' value");
            if (fos != null) {
                fos.flush();
                ((OutputStream)fos).close();
            }
        }
        catch (Exception e) {
            logger.error("update property[{}] error{}", (Object)propertyName, (Object)e.getMessage());
        }
    }
}

