/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.util.NumberUtils;
import com.sondertara.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtils.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomUtils.createSecureRandom(seed);
    }

    public static SecureRandom getSHA1PRNGRandom(byte[] seed) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaraException(e);
        }
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static SecureRandom getSecureRandomStrong() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtils.getSecureRandom() : RandomUtils.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtils.randomInt(2);
    }

    public static char randomChinese() {
        return (char)RandomUtils.randomInt(19968, 40959);
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomUtils.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtils.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomUtils.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomUtils.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return RandomUtils.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return RandomUtils.getRandom().nextDouble(min, max);
    }

    public static double randomDouble(double min, double max, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(min, max), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtils.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomUtils.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(limit.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal min, BigDecimal max) {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(min.doubleValue(), max.doubleValue()));
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomUtils.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtils.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        if (list.size() < limit) {
            limit = list.size();
        }
        return list.get(RandomUtils.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomUtils.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        if (array.length < limit) {
            limit = array.length;
        }
        return array[RandomUtils.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomUtils.randomEle(list, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomUtils.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringUpper(int length) {
        return RandomUtils.randomString(BASE_CHAR_NUMBER, length).toUpperCase();
    }

    public static String randomStringWithoutStr(int length, String elemData) {
        String baseStr = BASE_CHAR_NUMBER;
        baseStr = StringUtils.removeAll((CharSequence)baseStr, elemData.toLowerCase().toCharArray());
        return RandomUtils.randomString(baseStr, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtils.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (StringUtils.isEmpty(baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static char randomNumber() {
        return RandomUtils.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return RandomUtils.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomUtils.randomInt(baseString.length()));
    }
}

