/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.exception.TaraException;
import com.sondertara.common.function.Filter;
import com.sondertara.common.io.FileUtils;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.map.EnumerationIter;
import com.sondertara.common.lang.resource.ClassPathResource;
import com.sondertara.common.lang.resource.FileResource;
import com.sondertara.common.lang.resource.Resource;
import com.sondertara.common.util.ClassLoaderUtils;
import com.sondertara.common.util.StringUtils;
import com.sondertara.common.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtils {
    public static String readUtf8Str(String resource) {
        return ResourceUtils.readStr(resource, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public static String readStr(String resource, Charset charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream getStream(String resource) throws IOException {
        return ResourceUtils.getResourceObj(resource).getStream();
    }

    public static URL getResource(String resource) {
        return ResourceUtils.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        return ResourceUtils.getResources(resource, null);
    }

    public static List<URL> getResources(String resource, Filter<URL> filter) {
        ArrayList<URL> urls = new ArrayList<URL>();
        EnumerationIter<URL> iter = ResourceUtils.getResourceIter(resource);
        while (iter.hasNext()) {
            URL next = iter.next();
            if (!filter.accept(next)) continue;
            urls.add(next);
        }
        return urls;
    }

    public static EnumerationIter<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtils.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new TaraException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        resource = StringUtils.nullToEmpty(resource);
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtils.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        if (StringUtils.isNotBlank(path) && (path.startsWith("file:") || FileUtils.isAbsolutePath(path))) {
            return new FileResource(path);
        }
        return new ClassPathResource(path);
    }

    public static File getFile(URL resourceUrl, String description) {
        Assert.notNull(resourceUrl, "Resource URL must not be null", new Object[0]);
        if (!"file".equals(resourceUrl.getProtocol())) {
            throw new RuntimeException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        return new File(URLUtils.toURI(resourceUrl).getSchemeSpecificPart());
    }
}

