/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.util.CharUtils;
import com.sondertara.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSplitUtils {
    public static List<String> splitPath(String str) {
        return StringSplitUtils.splitPath(str, 0);
    }

    public static String[] splitPathToArray(String str) {
        return StringSplitUtils.toArray(StringSplitUtils.splitPath(str));
    }

    public static List<String> splitPath(String str, int limit) {
        return StringSplitUtils.split(str, '/', limit, true, true);
    }

    public static String[] splitPathToArray(String str, int limit) {
        return StringSplitUtils.toArray(StringSplitUtils.splitPath(str, limit));
    }

    public static List<String> splitTrim(String str, char separator, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, 0, true, ignoreEmpty);
    }

    public static List<String> split(String str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> splitTrim(String str, char separator, int limit, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, true, ignoreEmpty, false);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitIgnoreCase(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringSplitUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharUtils.equals(separator, str.charAt(i), ignoreCase)) continue;
            StringSplitUtils.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringSplitUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.toArray(StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str, String separator, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, true, ignoreEmpty);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(String str, String separator, int limit, boolean ignoreEmpty) {
        return StringSplitUtils.split(str, separator, limit, true, ignoreEmpty, true);
    }

    public static List<String> split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringSplitUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (StringUtils.isEmpty(separator)) {
            return StringSplitUtils.split(str, limit);
        }
        if (separator.length() == 1) {
            return StringSplitUtils.split(str, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StringUtils.indexOf((CharSequence)str, separator, start, ignoreCase)) > -1) {
            StringSplitUtils.addToList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StringSplitUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.toArray(StringSplitUtils.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str, int limit) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringSplitUtils.addToList(new ArrayList<String>(1), str, true, true);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharUtils.isBlankChar(str.charAt(i))) continue;
            StringSplitUtils.addToList(list, str.substring(start, i), true, true);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringSplitUtils.addToList(list, str.substring(start, len), true, true);
    }

    public static String[] splitToArray(String str, int limit) {
        return StringSplitUtils.toArray(StringSplitUtils.split(str, limit));
    }

    public static List<String> split(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StringUtils.isEmpty(str)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StringSplitUtils.addToList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (null == separatorPattern) {
            return StringSplitUtils.split(str, limit);
        }
        Matcher matcher = separatorPattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        while (matcher.find()) {
            StringSplitUtils.addToList(list, str.substring(start, matcher.start()), isTrim, ignoreEmpty);
            start = matcher.end();
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StringSplitUtils.addToList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StringSplitUtils.toArray(StringSplitUtils.split(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitByLength(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    private static List<String> addToList(List<String> list, String part, boolean isTrim, boolean ignoreEmpty) {
        if (isTrim) {
            part = StringUtils.trim(part);
        }
        if (!ignoreEmpty || !part.isEmpty()) {
            list.add(part);
        }
        return list;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }
}

