/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.sondertara.common.io.CharacterReader;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.lang.Pair;
import com.sondertara.common.util.ArrayUtils;
import com.sondertara.common.util.CharUtils;
import com.sondertara.common.util.StringFormatter;
import com.sondertara.common.util.StringSplitUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final char C_SLASH = '/';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String SLASH = "/";
    public static final String NULL = "null";
    public static final String COLON = ":";
    public static final char EMPTY_CHAR = '\u0000';
    private static final String NULL_STR = "null";
    private static final Pattern PHONE_PATTERN = Pattern.compile("^1[3456789][0-9]{9}$");
    public static final String EMPTY_STRING = "";
    private static final String AS = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtils.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringUtils.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return StringUtils.nullToDefault(str, "");
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToDefault(CharSequence str, String defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str.toString();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return StringUtils.isBlank(str) ? defaultStr : str.toString();
    }

    public static String emptyToNull(CharSequence str) {
        return StringUtils.isEmpty(str) ? null : str.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return StringUtils.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return true;
        }
        return StringUtils.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (StringUtils.isBlank(str)) {
            return true;
        }
        return StringUtils.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StringUtils.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? "" : StringUtils.trim(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = StringUtils.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String trimStart(CharSequence str) {
        return StringUtils.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return StringUtils.trim(str, 1);
    }

    public static String trim(CharSequence str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharUtils.isBlankChar(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharUtils.isBlankChar(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static boolean startWith(CharSequence str, char c) {
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase) {
        if (null == str || null == prefix) {
            return null == str && null == prefix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringUtils.startWith(str, prefix, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!StringUtils.startWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, char c) {
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return StringUtils.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StringUtils.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringUtils.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (StringUtils.isNotEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtils.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtils.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringUtils.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return StringUtils.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (getOrSetMethodNameStr.startsWith("is")) {
            return StringUtils.removePreAndLowerFirst(getOrSetMethodName, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return StringUtils.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return StringUtils.upperFirstAndAddPre(fieldName, "get");
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        return str.toString().replace(strToRemove, "");
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayUtils.isEmpty(chars)) {
            return StringUtils.str(str);
        }
        int len = str.length();
        if (0 == len) {
            return StringUtils.str(str);
        }
        StringBuilder builder = StringUtils.builder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtils.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAllLineBreaks(CharSequence str) {
        return StringUtils.removeAll(str, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return StringUtils.lowerFirst(StringUtils.removePrefix(str, prefix));
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StringUtils.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StringUtils.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + StringUtils.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringUtils.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringUtils.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringUtils.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StringUtils.lowerFirst(StringUtils.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return StringUtils.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        if (StringUtils.equals(str, prefixOrSuffix)) {
            return "";
        }
        return StringUtils.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringUtils.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (StringUtils.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(Math.min(from, to), Math.max(from, to));
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return StringUtils.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StringUtils.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (StringUtils.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        String prefix2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2.concat(str2);
        }
        return str2;
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        String suffix2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return StringUtils.str(str);
        }
        String str2 = str.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2.concat(suffix2);
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (CharUtils.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0, "empty charSequence", new Object[0]);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return StringUtils.sub(string, 0, length) + "...";
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringUtils.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return StringUtils.sub(string, fromIndex, string.length());
    }

    public static String subSufByLength(CharSequence string, int length) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return StringUtils.sub(string, -length, string.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return StringUtils.sub(input, fromIndex, fromIndex + length);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringUtils.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static List<String> split(CharSequence str, char separator) {
        return StringUtils.split(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        if (null == str) {
            return new String[0];
        }
        return StringSplitUtils.splitToArray(str.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StringUtils.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringUtils.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StringUtils.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return StringUtils.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return StringUtils.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringUtils.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StringSplitUtils.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StringSplitUtils.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StringSplitUtils.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static String[] split(CharSequence str, int len) {
        if (null == str) {
            return new String[0];
        }
        return StringSplitUtils.splitByLength(str.toString(), len);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0) {
            return "";
        }
        if (count == 1 || str.length() == 0) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence str, int padLen) {
        if (null == str) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return StringUtils.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtils.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        return StringUtils.equalsAny(str1, true, strs);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return StringUtils.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayUtils.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!StringUtils.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (ArrayUtils.isEmpty(params) || StringUtils.isBlank(template)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return StringUtils.bytes(str, StandardCharsets.UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return StringUtils.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return StringUtils.bytes(str, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String utf8Str(Object obj) {
        return StringUtils.str(obj, StandardCharsets.UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StringUtils.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtils.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringUtils.str(bytes, StringUtils.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtils.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toString(Object obj) {
        return null == obj ? "null" : obj.toString();
    }

    public static ByteBuffer byteBuffer(CharSequence str, String charset) {
        return ByteBuffer.wrap(StringUtils.bytes(str, charset));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtils.join(objs, conjunction);
    }

    public static String toUnderlineCase(CharSequence str) {
        return StringUtils.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && Character.isUpperCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (sb.length() > 0 && Character.isUpperCase(sb.charAt(sb.length() - 1)) && symbol != c) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeAllSpace(String s) {
        return org.apache.commons.lang3.StringUtils.join((Object[])s.split("\\s"), (String)"").trim();
    }

    public static String trimAllSpace(String s) {
        return org.apache.commons.lang3.StringUtils.join((Object[])s.split("\\s+"), (String)SPACE);
    }

    public static String camelToText(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = ' ';
        for (char c : s.toCharArray()) {
            char nc = c;
            if (Character.isUpperCase(nc) && Character.isLowerCase(lastChar)) {
                buf.append(SPACE);
                nc = Character.toLowerCase(c);
            } else if (Character.isDigit(lastChar) && Character.isLetter(c) || Character.isDigit(c) && Character.isLetter(lastChar)) {
                if (lastChar != ' ') {
                    buf.append(SPACE);
                }
                nc = Character.toLowerCase(c);
            }
            if (lastChar != ' ' || c != ' ') {
                buf.append(nc);
            }
            lastChar = c;
        }
        return buf.toString();
    }

    public static String capitalizeFirstWord(String str, char[] delimiters) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        boolean done = false;
        Set<Integer> delimiterSet = StringUtils.generateDelimiterSet(delimiters);
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        boolean capitalizeNext = true;
        int index = 0;
        while (index < strLen) {
            int codePoint = str.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                capitalizeNext = true;
                newCodePoints[outOffset++] = codePoint;
                index += Character.charCount(codePoint);
                continue;
            }
            if (!done && capitalizeNext && Character.isLowerCase(codePoint)) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                done = true;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String capitalizeFirstWord(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        boolean upperNext = true;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetter(c) && upperNext) {
                buf.append(Character.toUpperCase(c));
                upperNext = false;
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                upperNext = true;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static Set<Integer> generateDelimiterSet(char[] delimiters) {
        HashSet<Integer> delimiterHashSet = new HashSet<Integer>();
        if (delimiters != null && delimiters.length != 0) {
            for (int index = 0; index < delimiters.length; ++index) {
                delimiterHashSet.add(Character.codePointAt(delimiters, index));
            }
        } else if (delimiters == null) {
            delimiterHashSet.add(Character.codePointAt(new char[]{' '}, 0));
        }
        return delimiterHashSet;
    }

    public static String toSoftCamelCase(String s) {
        Object[] words = s.split("[\\s_]");
        for (int i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalizeFirstWord((String)words[i]);
        }
        return org.apache.commons.lang3.StringUtils.join((Object[])words);
    }

    public static String toCamelCase(String s) {
        Object[] words = org.apache.commons.lang3.StringUtils.splitByCharacterTypeCamelCase((String)s);
        boolean firstWord = true;
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            if (firstWord && StringUtils.startsWithLetter((String)word)) {
                words[i] = ((String)word).toLowerCase();
                firstWord = false;
                if (i <= 1 || !StringUtils.isBlank((CharSequence)words[i - 1]) || !StringUtils.isAllLetterOrDigit((String)words[i - 2])) continue;
                words[i - 1] = "";
                continue;
            }
            if (StringUtils.specialWord((String)word)) {
                firstWord = true;
                continue;
            }
            words[i] = org.apache.commons.lang3.StringUtils.capitalize((String)((String)word).toLowerCase());
            if (i <= 1 || !StringUtils.isBlank((CharSequence)words[i - 1]) || !StringUtils.isAllLetterOrDigit((String)words[i - 2])) continue;
            words[i - 1] = "";
        }
        String join = org.apache.commons.lang3.StringUtils.join((Object[])words);
        join = StringUtils.replaceSeparatorBetweenLetters(join, '_', '\u0000');
        join = StringUtils.replaceSeparatorBetweenLetters(join, '-', '\u0000');
        join = StringUtils.replaceSeparatorBetweenLetters(join, '.', '\u0000');
        return join;
    }

    private static boolean isAllLetterOrDigit(String word) {
        for (char c : word.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String unCameCase(String val, char separator) {
        try {
            if (StringUtils.isNotEmpty(val)) {
                CharacterReader charReader = new CharacterReader(val);
                StringBuilder result = new StringBuilder();
                while (charReader.hasMore()) {
                    char ch = charReader.next();
                    if (ch >= 'A' && ch <= 'Z') {
                        result.append(separator).append((char)(ch + 32));
                        continue;
                    }
                    if (ch == separator) continue;
                    result.append(ch);
                }
                return result.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String toCapitalizeCamelCase(String str) {
        if (null == str) {
            return null;
        }
        str = StringUtils.toCamelCase(str);
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static boolean specialWord(String word) {
        if (StringUtils.isBlank(word)) {
            return false;
        }
        for (char c : word.toCharArray()) {
            if (!Character.isDigit(c) && !Character.isLetter(c) && !StringUtils.isSeparator(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithLetter(String word) {
        return word.length() > 0 && Character.isLetter(word.charAt(0));
    }

    private static boolean isNotQuote(String word) {
        return !"\"".equals(word) && !"'".equals(word);
    }

    public static String wordsToConstantCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '_' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '_') {
                buf.append("_");
            }
            if (!Character.isWhitespace(c)) {
                buf.append(Character.toUpperCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("_");
        }
        return buf.toString();
    }

    public static String wordsAndHyphenAndCamelToConstantCase(String s) {
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean isUpperCaseAndPreviousIsLowerCase;
            char c = chars[i];
            boolean isUpperCaseAndPreviousIsUpperCase = Character.isUpperCase(previousChar) && Character.isUpperCase(c);
            boolean bl = isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            if (Character.isLetter(c) && Character.isLetter(previousChar) && (isUpperCaseAndPreviousIsLowerCase || isUpperCaseAndPreviousIsUpperCase)) {
                buf.append("_");
            } else if (Character.isDigit(previousChar) && Character.isLetter(c) || Character.isDigit(c) && Character.isLetter(previousChar)) {
                buf.append('_');
            }
            if ((StringUtils.isSeparator(c) || Character.isWhitespace(c)) && Character.isLetterOrDigit(previousChar) && StringUtils.nextIsLetterOrDigit(s, i)) {
                buf.append('_');
            } else {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        return buf.toString();
    }

    private static boolean betweenLettersOrDigits(char[] chars, int i) {
        char aChar;
        int j;
        for (j = i; j < chars.length; ++j) {
            aChar = chars[j];
            if (!Character.isLetterOrDigit(aChar) && !Character.isWhitespace(aChar)) {
                return false;
            }
            if (Character.isLetterOrDigit(aChar)) break;
        }
        for (j = i; j >= 0; --j) {
            aChar = chars[j];
            if (!Character.isLetterOrDigit(aChar) && !Character.isWhitespace(aChar)) {
                return false;
            }
            if (Character.isLetterOrDigit(aChar)) break;
        }
        return true;
    }

    private static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static boolean isNotBorderQuote(char actualChar, int i, char[] chars) {
        if (chars.length - 1 == i) {
            char firstChar = chars[0];
            return StringUtils.isQuote(actualChar) && StringUtils.isQuote(firstChar);
        }
        return false;
    }

    private static boolean isQuote(char actualChar) {
        return actualChar == '\'' || actualChar == '\"';
    }

    public static String toDotCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = ' ';
        for (char c : s.toCharArray()) {
            boolean lastOneIsNotUnderscore;
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(lastChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(lastChar);
            boolean bl = lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '.';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace)) {
                buf.append(DOT);
            } else if (Character.isDigit(lastChar) && Character.isLetter(c) || Character.isDigit(c) && Character.isLetter(lastChar)) {
                buf.append(DOT);
            }
            if (c == '.') {
                buf.append('.');
            } else if (c == '-') {
                buf.append('.');
            } else if (c == '_') {
                buf.append('.');
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append(DOT);
        }
        return buf.toString();
    }

    public static String replaceSeparator(String s1, char s, char s2) {
        return s1.replace(s, s2);
    }

    public static String replaceSeparatorBetweenLetters(String s, char from, char to) {
        StringBuilder buf = new StringBuilder();
        char lastChar = ' ';
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == from) {
                boolean lastDigit = Character.isDigit(lastChar);
                boolean lastLetterOrDigit = Character.isLetterOrDigit(lastChar);
                boolean nextDigit = StringUtils.nextIsDigit(s, i);
                boolean nextLetterOrDigit = StringUtils.nextIsLetterOrDigit(s, i);
                if (lastDigit && nextDigit) {
                    buf.append(c);
                } else if (lastLetterOrDigit && nextLetterOrDigit) {
                    if (to != '\u0000') {
                        buf.append(to);
                    }
                } else {
                    buf.append(c);
                }
            } else {
                buf.append(c);
            }
            lastChar = c;
        }
        return buf.toString();
    }

    private static boolean nextIsDigit(String s, int i) {
        if (i + 1 >= s.length()) {
            return false;
        }
        return Character.isDigit(s.charAt(i + 1));
    }

    private static boolean nextIsLetterOrDigit(String s, int i) {
        if (i + 1 >= s.length()) {
            return false;
        }
        return Character.isLetterOrDigit(s.charAt(i + 1));
    }

    private static boolean nextIsLetter(String s, int i) {
        if (i + 1 >= s.length()) {
            return false;
        }
        return Character.isLetter(s.charAt(i + 1));
    }

    public static String[] splitPreserveAllTokens(String input, String regex) {
        int index = 0;
        Pattern p = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = p.matcher(input);
        while (m.find()) {
            if (!StringUtils.isNotEmpty(m.group())) continue;
            String match = input.subSequence(index, m.start()).toString();
            if (StringUtils.isNotEmpty(match)) {
                result.add(match);
            }
            result.add(input.subSequence(m.start(), m.end()).toString());
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input};
        }
        String remaining = input.subSequence(index, input.length()).toString();
        if (StringUtils.isNotEmpty(remaining)) {
            result.add(remaining);
        }
        return result.toArray(new String[0]);
    }

    public static String nonAsciiToUnicode(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!CharUtils.isAscii(c.charValue())) {
                sb.append(org.apache.commons.lang3.CharUtils.unicodeEscaped((Character)c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapedUnicodeToString(String s) {
        Object[] parts = StringUtils.splitPreserveAllTokens(s, "\\\\u[0-9a-fA-F]{4}");
        for (int i = 0; i < parts.length; ++i) {
            if (!((String)parts[i]).startsWith("\\u")) continue;
            int v = Integer.parseInt(((String)parts[i]).substring(2), 16);
            parts[i] = "" + (char)v;
        }
        return org.apache.commons.lang3.StringUtils.join((Object[])parts);
    }

    public static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append('-');
            } else if ('.' == c) {
                buf.append('-');
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }

    public static boolean containsLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAnyButWhitespace(String cs) {
        if (StringUtils.isEmpty(cs)) {
            return cs.length();
        }
        int csLen = cs.length();
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return i;
        }
        return cs.length();
    }

    public static String substringUntilSpecialCharacter(String s) {
        int firstLetterOrDigitOrSeparator = -1;
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!(Character.isLetterOrDigit(c) || Character.isWhitespace(c) || StringUtils.isSeparator(c) || firstLetterOrDigitOrSeparator == -1)) {
                return s.substring(firstLetterOrDigitOrSeparator, i);
            }
            if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && !StringUtils.isSeparator(c) || firstLetterOrDigitOrSeparator != -1) continue;
            firstLetterOrDigitOrSeparator = i;
        }
        return s;
    }

    public static boolean isSeparator(char c) {
        return c == '.' || c == '-' || c == '_';
    }

    public static boolean containsOnlyLettersAndDigits(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean noUpperCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String removeBorderQuotes(String s) {
        if (StringUtils.isQuoted(s)) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String selectedText) {
        return selectedText != null && selectedText.length() > 2 && (StringUtils.isBorderChar(selectedText, "\"") || StringUtils.isBorderChar(selectedText, "'"));
    }

    public static boolean isBorderChar(String s, String borderChar) {
        return s.startsWith(borderChar) && s.endsWith(borderChar);
    }

    public static boolean noLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsUpperCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsUpperCaseAfterLowerCase(String s) {
        char[] charArray;
        char previous = ' ';
        for (char c : charArray = s.toCharArray()) {
            if (Character.isUpperCase(c) && Character.isLetter(previous) && Character.isLowerCase(previous)) {
                return true;
            }
            previous = c;
        }
        return false;
    }

    public static boolean isCapitalizedFirstButNotAll(String str) {
        int codePoint;
        if (str.length() == 0) {
            return false;
        }
        Set<Integer> delimiterSet = StringUtils.generateDelimiterSet(new char[]{' '});
        int strLen = str.length();
        int firstCapitalizedIndex = -1;
        boolean someUncapitalized = false;
        boolean afterSeparatorOrFirst = true;
        for (int index = 0; index < strLen; index += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                afterSeparatorOrFirst = true;
                continue;
            }
            if (Character.isLowerCase(codePoint) && afterSeparatorOrFirst) {
                if (firstCapitalizedIndex == -1) {
                    return false;
                }
                someUncapitalized = true;
                afterSeparatorOrFirst = false;
                continue;
            }
            if (!Character.isUpperCase(codePoint) || !afterSeparatorOrFirst) continue;
            if (firstCapitalizedIndex == -1) {
                firstCapitalizedIndex = index;
            }
            afterSeparatorOrFirst = false;
        }
        return firstCapitalizedIndex != -1 && someUncapitalized;
    }

    public static boolean startsWithUppercase(String s) {
        char[] charArray;
        for (char c : charArray = s.toCharArray()) {
            if (Character.isLetter(c) && Character.isLowerCase(c)) {
                return false;
            }
            if (!Character.isLetter(c) || !Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean noSeparators(String s, char ... delimiters) {
        if (s.length() == 0) {
            return true;
        }
        Set<Integer> delimiterSet = StringUtils.generateDelimiterSet(delimiters);
        boolean letterFound = false;
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (Character.isLetterOrDigit(c)) {
                letterFound = true;
                continue;
            }
            if (!letterFound || !delimiterSet.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSeparatorBetweenLetters(String s, char separator) {
        char previous = '?';
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == separator && Character.isLetterOrDigit(previous) && StringUtils.nextIsLetterOrDigit(s, i)) {
                return true;
            }
            previous = c;
        }
        return false;
    }

    public static List<String> splitToTokensBySpace(String originalText) {
        char[] chars = originalText.toCharArray();
        ArrayList<String> result = new ArrayList<String>();
        int whiteSpaceBeginning = -1;
        int tokenBeginning = -1;
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == ' ') {
                if (whiteSpaceBeginning == -1) {
                    whiteSpaceBeginning = i;
                }
                if (tokenBeginning == -1) continue;
                result.add(new String(Arrays.copyOfRange(chars, tokenBeginning, i)));
                tokenBeginning = -1;
                continue;
            }
            if (whiteSpaceBeginning != -1) {
                result.add(new String(Arrays.copyOfRange(chars, whiteSpaceBeginning, i)));
                whiteSpaceBeginning = -1;
            }
            if (tokenBeginning != -1) continue;
            tokenBeginning = i;
        }
        if (tokenBeginning != -1) {
            result.add(new String(Arrays.copyOfRange(chars, tokenBeginning, chars.length)));
        }
        if (whiteSpaceBeginning != -1) {
            result.add(new String(Arrays.copyOfRange(chars, whiteSpaceBeginning, chars.length)));
        }
        return result;
    }

    public static String toSpringEnvVariable(String s) {
        return Arrays.stream(StringUtils.split((CharSequence)s, DOT)).map(StringUtils::trim).map(str -> StringUtils.replaceChars((CharSequence)str, "-", (CharSequence)"")).map(str -> StringUtils.replaceChars((CharSequence)str, "_", (CharSequence)"")).collect(Collectors.joining("_")).toUpperCase();
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return StringUtils.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StringUtils.nullToEmpty(prefix).concat(StringUtils.nullToEmpty(str)).concat(StringUtils.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StringUtils.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StringUtils.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (StringUtils.isNotEmpty(str)) {
            len += str.length();
        }
        if (StringUtils.isNotEmpty(prefix)) {
            len += str.length();
        }
        if (StringUtils.isNotEmpty(suffix)) {
            len += str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (StringUtils.isNotEmpty(prefix) && !StringUtils.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (StringUtils.isNotEmpty(str)) {
            sb.append(str);
        }
        if (StringUtils.isNotEmpty(suffix) && !StringUtils.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return StringUtils.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = StringUtils.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (StringUtils.isWrap(str, prefix, suffix)) {
            return StringUtils.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return StringUtils.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return StringUtils.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayUtils.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return StringUtils.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return StringUtils.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringUtils.subPre(str, minLength);
        }
        return StringUtils.repeatByLength(padStr, minLength - strLen).concat(str.toString());
    }

    public static String padPre(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringUtils.subPre(str, minLength);
        }
        return StringUtils.repeat(padChar, minLength - strLen).concat(str.toString());
    }

    public static String padAfter(CharSequence str, int minLength, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringUtils.sub(str, strLen - minLength, strLen);
        }
        return str.toString().concat(StringUtils.repeat(padChar, minLength - strLen));
    }

    public static String padAfter(CharSequence str, int minLength, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == minLength) {
            return str.toString();
        }
        if (strLen > minLength) {
            return StringUtils.subSufByLength(str, minLength);
        }
        return str.toString().concat(StringUtils.repeatByLength(padStr, minLength - strLen));
    }

    public static String center(CharSequence str, int size) {
        return StringUtils.center(str, size, ' ');
    }

    public static String center(CharSequence str, int size, char padChar) {
        if (str == null || size <= 0) {
            return StringUtils.str(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        str = StringUtils.padPre(str, strLen + pads / 2, padChar);
        str = StringUtils.padAfter(str, size, padChar);
        return str.toString();
    }

    public static String center(CharSequence str, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return StringUtils.str(str);
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        str = StringUtils.padPre(str, strLen + pads / 2, padStr);
        str = StringUtils.padAfter(str, size, padStr);
        return str.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StringUtils.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static Pair<Integer, Integer> countAndIndex(CharSequence content, CharSequence strForSearch) {
        if (StringUtils.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return Pair.of(0, -1);
        }
        int count = 0;
        int idx = 0;
        int lastIdx = -1;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            lastIdx = idx += strForSearch.length();
        }
        return Pair.of(count, lastIdx);
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringUtils.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (str.length() + 3 <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length();
        String str2 = str.toString();
        return StringUtils.format("{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtils.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringUtils.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtils.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtils.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i > 0; --i) {
            if (!StringUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return StringUtils.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (str == null || StringUtils.isEmpty(suffix) || StringUtils.endWith(str, suffix, ignoreCase)) {
            return StringUtils.str(str);
        }
        if (suffixes != null && suffixes.length > 0) {
            for (CharSequence s : suffixes) {
                if (!StringUtils.endWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return StringUtils.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || StringUtils.isEmpty(prefix) || StringUtils.startWith(str, prefix, ignoreCase)) {
            return StringUtils.str(str);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!StringUtils.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StringUtils.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String str, char filledChar, int len) {
        return StringUtils.fill(str, filledChar, len, false);
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StringUtils.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StringUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (StringUtils.isEmpty(str) || null == chars || chars.length() == 0) {
            return StringUtils.str(str);
        }
        return StringUtils.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(chars)) {
            return StringUtils.str(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = StringUtils.builder();
        for (int i = 0; i < strLen; ++i) {
            char c;
            if (i > 0) {
                // empty if block
            }
            builder.append(set.contains(Character.valueOf(c = str.charAt(i))) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        if (null == str || position < 0) {
            return false;
        }
        return str.length() > position && c == str.charAt(position);
    }

    public static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (CharSequence str : strs) {
            totalLength += null == str ? 0 : str.length();
        }
        return totalLength;
    }

    public static boolean isUpperCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static String swapCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static boolean isBlank(Object str) {
        return str == null || "".equals(str.toString().trim()) || "null".equalsIgnoreCase(str.toString().trim());
    }

    public static String convertNullToEmpty(Object str) {
        if (str == null) {
            return "";
        }
        return str.toString();
    }

    public static String convertNullToZero(Object str) {
        return StringUtils.convertToNumber(str, 0);
    }

    public static String convertNullToNull(Object str) {
        if (str == null || "".equals(str.toString().trim()) || "null".equalsIgnoreCase(str.toString().trim())) {
            return null;
        }
        return str.toString();
    }

    public static String convertToNumber(Object str) {
        if (str == null || "".equals(str.toString().trim()) || "null".equalsIgnoreCase(str.toString().trim())) {
            return null;
        }
        String s = org.apache.commons.lang3.StringUtils.deleteWhitespace((String)str.toString());
        if (s.endsWith("%")) {
            double v = Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0;
            return String.valueOf(v);
        }
        return String.valueOf(str);
    }

    public static String convertToNumber(Object str, Number defaultValue) {
        if (str == null || "".equals(str.toString().trim()) || "null".equalsIgnoreCase(str.toString().trim())) {
            return String.valueOf(defaultValue);
        }
        String s = org.apache.commons.lang3.StringUtils.deleteWhitespace((String)str.toString());
        if (s.endsWith("%")) {
            double v = Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0;
            return String.valueOf(v);
        }
        return String.valueOf(str);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isBlank(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getStringLen(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        return str.length();
    }

    public static String convertEncode(String strIn, String encoding, String targetEncoding) {
        String strOut;
        block6: {
            strOut = strIn;
            if (strIn == null) {
                return null;
            }
            try {
                if (encoding != null && targetEncoding != null) {
                    strOut = new String(strIn.getBytes(encoding), targetEncoding);
                    break block6;
                }
                if (encoding != null) {
                    strOut = new String(strIn.getBytes(encoding));
                    break block6;
                }
                if (targetEncoding != null) {
                    strOut = new String(strIn.getBytes(), targetEncoding);
                    break block6;
                }
                return strOut;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.out.println("Unsupported Encoding: " + encoding);
            }
        }
        return strOut;
    }

    public static String extractString(String str, String startStr, String endStr) {
        int startIdx;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (startStr == null) {
            startStr = "";
        }
        startIdx = (startIdx = str.indexOf(startStr)) == -1 ? 0 : (startIdx += startStr.length());
        int endIdx = str.length();
        if (endStr != null && (endIdx = str.indexOf(endStr, startIdx)) == -1) {
            endIdx = str.length();
        }
        return str.substring(startIdx, endIdx);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, -1);
    }

    public static String replaceSpace(String text) {
        return StringUtils.replace(text, SPACE, "");
    }

    public static String replace(String text, String repl, String with, int max) {
        int end;
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text, start, end).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        if (start == 0) {
            return text;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String trim(String str) {
        return StringUtils.trim(str, null, 0);
    }

    public static String trim(String str, String stripChars) {
        return StringUtils.trim(str, stripChars, 0);
    }

    public static String trimStart(String str) {
        return StringUtils.trim(str, null, -1);
    }

    public static String trimStart(String str, String stripChars) {
        return StringUtils.trim(str, stripChars, -1);
    }

    public static String trimEnd(String str) {
        return StringUtils.trim(str, null, 1);
    }

    public static String trimEnd(String str, String stripChars) {
        return StringUtils.trim(str, stripChars, 1);
    }

    public static String trimToNull(String str) {
        return StringUtils.trimToNull(str, null);
    }

    public static String trimToNull(String str, String stripChars) {
        String result = StringUtils.trim(str, stripChars);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str) {
        return StringUtils.trimToEmpty(str, null);
    }

    public static String trimToEmpty(String str, String stripChars) {
        String result = StringUtils.trim(str, stripChars);
        if (result == null) {
            return "";
        }
        return result;
    }

    private static String trim(String str, String stripChars, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            if (stripChars == null) {
                for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && stripChars.indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
        }
        if (mode >= 0) {
            if (stripChars == null) {
                while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(StringBuffer str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StringUtils.delimitedListToStringArray(str, COMMA);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(str.substring(i, i + 1));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(str.substring(pos, delPos));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(str.substring(pos));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[0]);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isAnyEmpty(String ... s) {
        if (s == null) {
            return true;
        }
        for (String str : s) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(String ... s) {
        if (s == null) {
            return true;
        }
        for (String str : s) {
            if (!StringUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static String reverse(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        return sb.reverse().toString();
    }

    public static String escapeHtml(String str) {
        if (str == null) {
            return "";
        }
        str = str.replace(">", "&gt;");
        str = str.replace("<", "&lt;");
        return str;
    }

    public static String limitString(String s, int byteLength, String omit) {
        if (s == null) {
            return null;
        }
        if (byteLength <= 0) {
            return "";
        }
        if (s.getBytes().length <= byteLength) {
            return s;
        }
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String tmp = s.substring(i, i + 1);
            if (r.toString().getBytes().length + tmp.getBytes().length > byteLength) break;
            r.append(tmp);
        }
        if (omit != null) {
            r.append(omit);
        }
        return r.toString();
    }

    public static String getPatternMatchStr(String src, String pattern) {
        if (src == null) {
            return null;
        }
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(src);
            if (matcher.find()) {
                return matcher.group();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = AS.charAt((int)(Math.random() * (double)AS.length()));
            sb.append(c);
        }
        return sb.toString().toUpperCase();
    }

    public static boolean isAsciiStr(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.length() == 0 || subStr == null || subStr.length() == 0) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(subStr, index)) != -1) {
            ++count;
            index += subStr.length();
        }
        return count;
    }

    public static String readLine(InputStreamReader inputReader) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        int num = 0;
        while ((n = inputReader.read()) > 0) {
            ++num;
            char c = (char)n;
            if (c == '\n' || c == '\r') break;
            sb.append(c);
        }
        if (num == 0) {
            return null;
        }
        return sb.toString();
    }

    public static String filterAsciiStr(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u00ff') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getAsciiStr(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u00ff') continue;
            sb.append(c);
        }
        return StringUtils.trim(sb.toString());
    }

    public static String getLetterOrDigit(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isPhone(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return false;
        }
        try {
            Matcher m = PHONE_PATTERN.matcher(phone);
            boolean b = m.matches();
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String escapeQueryChars(String s) {
        if (StringUtils.isEmpty(s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || c == '/' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimCtrlChars(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        boolean containCtrlChar = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= ' ' || c == '\n' || c == '\r') continue;
            containCtrlChar = true;
            break;
        }
        if (containCtrlChar) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c < ' ' && c != '\n' && c != '\r') continue;
                sb.append(c);
            }
            str = sb.toString();
        }
        return str;
    }

    public static int countLines(String str) {
        if (null == str || str.length() == 0) {
            return 0;
        }
        int line = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if ('\r' == c) {
                ++line;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if ('\n' != c) continue;
            ++line;
        }
        return line;
    }

    public static String removeWhiteLines(String str) {
        if (null == str || str.length() == 0) {
            return str;
        }
        String all = str.replaceAll("(?m)^\\s*$(\\n|\\r\\n)", "");
        return StringUtils.trim(all);
    }
}

