/*
 * Decompiled with CFR 0.152.
 */
package com.sonsure.matrix.tile.shiro.config;

import com.sonsure.matrix.basic.context.PlatformContextHolder;
import com.sonsure.matrix.osgi.runtime.OsgiService;
import com.sonsure.matrix.tile.essential.provider.impl.SimpleUrlDefinitionProvider;
import com.sonsure.matrix.tile.shiro.filter.ShiroRestPermissionsAuthorizationFilter;
import com.sonsure.matrix.tile.shiro.match.BCryptCredentialsMatcher;
import com.sonsure.matrix.tile.shiro.realm.UserAuthorizationRealm;
import com.sonsure.matrix.tile.shiro.realm.UserAuthorizationRealmComposite;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;

@Configuration
public class ShiroConfiguration {
    public static final String PERMISSION_CFG = "permission_cfg";
    public static final String ACTIVE_AUTHORIZING_REALMS = "active_authorizing_realms";

    @Bean(name={"shiroFilter"})
    @Order(value=-2147483639)
    public ShiroFilterFactoryBean shiroFilterFactoryBean() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(this.securityManager());
        shiroFilterFactoryBean.setLoginUrl("/user/login");
        shiroFilterFactoryBean.setSuccessUrl("/wb/index");
        shiroFilterFactoryBean.setUnauthorizedUrl("/error/403");
        LinkedHashMap<String, ShiroRestPermissionsAuthorizationFilter> filters = new LinkedHashMap<String, ShiroRestPermissionsAuthorizationFilter>();
        filters.put("ss_perm", new ShiroRestPermissionsAuthorizationFilter());
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/user/logout", "logout");
        for (String openUrl : SimpleUrlDefinitionProvider.DEFAULT_OPEN_URLS) {
            String url = StringUtils.substring((String)openUrl, (int)"all:".length());
            if (StringUtils.equals((CharSequence)url, (CharSequence)"/user/login") || StringUtils.equals((CharSequence)url, (CharSequence)"/user/logout")) continue;
            filterChainDefinitionMap.put(url, "anon");
        }
        filterChainDefinitionMap.put("/**", "ss_perm");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean
    @DependsOn(value={"platformContext"})
    public SessionManager sessionManager() {
        String cookieName = PlatformContextHolder.getPlatformContext().getPlatformProperties(false).getCookieName();
        if (StringUtils.isBlank((CharSequence)cookieName)) {
            cookieName = "shiro_cookie";
        }
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        SimpleCookie cookie = new SimpleCookie(cookieName);
        cookie.setPath("/");
        sessionManager.setSessionIdCookie((Cookie)cookie);
        return sessionManager;
    }

    @Bean
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.userAuthorizationRealmComposite());
        securityManager.setSessionManager(this.sessionManager());
        return securityManager;
    }

    @OsgiService(value=AuthorizingRealm.class)
    @Bean
    public UserAuthorizationRealm userAuthorizationRealm() {
        UserAuthorizationRealm userAuthorizationRealm = new UserAuthorizationRealm();
        userAuthorizationRealm.setName("local_authenticating_realm");
        userAuthorizationRealm.setCredentialsMatcher(this.bCryptCredentialsMatcher());
        return userAuthorizationRealm;
    }

    @Bean
    public UserAuthorizationRealmComposite userAuthorizationRealmComposite() {
        UserAuthorizationRealmComposite userRealm = new UserAuthorizationRealmComposite();
        userRealm.setCachingEnabled(false);
        return userRealm;
    }

    @Bean
    public BCryptCredentialsMatcher bCryptCredentialsMatcher() {
        return new BCryptCredentialsMatcher();
    }

    @Bean
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(this.securityManager());
        return authorizationAttributeSourceAdvisor;
    }
}

