/*
 * Decompiled with CFR 0.152.
 */
package com.sonsure.matrix.tile.shiro.filter;

import com.sonsure.matrix.basic.context.LoginUser;
import com.sonsure.matrix.tile.user.vo.AnonymousLoginUser;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;

public class ShiroRestPermissionsAuthorizationFilter
extends PermissionsAuthorizationFilter {
    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        Subject subject = this.getSubject(request, response);
        LoginUser loginUser = (LoginUser)subject.getPrincipal();
        if (loginUser == null) {
            loginUser = new AnonymousLoginUser();
        }
        String method = ((HttpServletRequest)request).getMethod();
        String requestURI = this.getPathWithinApplication(request);
        int index = StringUtils.indexOf((CharSequence)requestURI, (CharSequence)".");
        if (index != -1) {
            requestURI = StringUtils.substring((String)requestURI, (int)0, (int)index);
        }
        return loginUser.hasPermission(requestURI, method);
    }
}

