/*
 * Decompiled with CFR 0.152.
 */
package com.sonsure.matrix.tile.shiro.impl;

import com.sonsure.commons.validation.Verifier;
import com.sonsure.matrix.basic.context.LoginUser;
import com.sonsure.matrix.basic.context.PlatformContextHolder;
import com.sonsure.matrix.basic.exception.FailedMessageException;
import com.sonsure.matrix.basic.exception.PlatformException;
import com.sonsure.matrix.osgi.runtime.OsgiService;
import com.sonsure.matrix.tile.permission.service.RoleService;
import com.sonsure.matrix.tile.permission.service.UserPermService;
import com.sonsure.matrix.tile.permission.vo.RoleVo;
import com.sonsure.matrix.tile.user.provider.UserAuthenticationProvider;
import com.sonsure.matrix.tile.user.provider.UserToken;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@OsgiService(value=UserAuthenticationProvider.class)
@Order(value=2147003647)
public class ShiroUserAuthenticationProvider
implements UserAuthenticationProvider {
    public boolean isSelfVerifySession() {
        return true;
    }

    public LoginUser getLoginUser() {
        Subject subject = SecurityUtils.getSubject();
        return (LoginUser)subject.getPrincipal();
    }

    public LoginUser login(UserToken userToken) {
        Verifier.init().notBlank(userToken.getUsername(), "\u7528\u6237\u540d").notBlank(userToken.getPassword(), "\u5bc6\u7801").validate();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(userToken.getUsername(), userToken.getPassword());
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            return (LoginUser)subject.getPrincipal();
        }
        catch (AuthenticationException e) {
            if (e.getCause() instanceof PlatformException) {
                throw new FailedMessageException(e.getCause().getMessage(), (Throwable)e);
            }
            throw new FailedMessageException("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", (Throwable)e);
        }
    }

    public Set<String> getPermRestUrls() {
        RoleService roleService;
        List localRoles;
        Set roleCodes;
        UserPermService userPermService = (UserPermService)PlatformContextHolder.getServiceBean(UserPermService.class);
        LoginUser loginUser = this.getLoginUser();
        Set userPermRestUrls = userPermService.findUserPermRestUrls(loginUser.getUserId());
        if (!StringUtils.equals((CharSequence)"local_authenticating_realm", (CharSequence)loginUser.getUserRealm()) && (roleCodes = loginUser.getRoleCodes()) != null && CollectionUtils.isNotEmpty((Collection)(localRoles = (roleService = (RoleService)PlatformContextHolder.getServiceBean(RoleService.class)).findRolesByCodes(roleCodes.toArray(new String[0]))))) {
            List<Long> localRolesIds = localRoles.stream().map(RoleVo::getRoleId).collect(Collectors.toList());
            Set rolePermRestUrls = userPermService.findRolePermRestUrls(localRolesIds.toArray(new Long[0]));
            userPermRestUrls.addAll(rolePermRestUrls);
        }
        return userPermRestUrls;
    }

    public void updateLoginUser(LoginUser loginUser) {
        Subject subject = SecurityUtils.getSubject();
        PrincipalCollection principalCollection = subject.getPrincipals();
        String realmName = (String)principalCollection.getRealmNames().iterator().next();
        SimplePrincipalCollection newPrincipalCollection = new SimplePrincipalCollection((Object)loginUser, realmName);
        subject.runAs((PrincipalCollection)newPrincipalCollection);
    }

    public void logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
    }
}

