/*
 * Decompiled with CFR 0.152.
 */
package com.sonsure.matrix.tile.shiro.realm;

import com.sonsure.commons.bean.BeanKit;
import com.sonsure.matrix.basic.context.PlatformContextHolder;
import com.sonsure.matrix.basic.exception.FailedMessageException;
import com.sonsure.matrix.tile.user.enums.UserStatus;
import com.sonsure.matrix.tile.user.service.UserService;
import com.sonsure.matrix.tile.user.vo.DefaultLoginUser;
import com.sonsure.matrix.tile.user.vo.UserVo;
import java.util.ArrayList;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class UserAuthorizationRealm
extends AuthorizingRealm {
    public static final String LOCAL_AUTHENTICATING_REALM = "local_authenticating_realm";

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String username = (String)principals.getPrimaryPrincipal();
        UserService userService = (UserService)PlatformContextHolder.getServiceBean(UserService.class);
        UserVo userVo = userService.getByUsername(username);
        if (userVo == null) {
            return null;
        }
        if (UserStatus.isDisable((String)userVo.getStatus().getCode())) {
            throw new FailedMessageException("\u7528\u6237\u7981\u6b62\u767b\u5f55");
        }
        ArrayList userRoles = new ArrayList();
        ArrayList userPermissions = new ArrayList();
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        authorizationInfo.addRoles(userRoles);
        authorizationInfo.addStringPermissions(userPermissions);
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String username = (String)authenticationToken.getPrincipal();
        UserService userService = (UserService)PlatformContextHolder.getServiceBean(UserService.class);
        UserVo userVo = userService.getByUsernameOrEmail(username);
        if (userVo == null) {
            return null;
        }
        if (UserStatus.isDisable((String)userVo.getStatus().getCode())) {
            throw new FailedMessageException("\u7528\u6237\u7981\u6b62\u767b\u5f55");
        }
        DefaultLoginUser defaultLoginUser = (DefaultLoginUser)BeanKit.copyProperties((Object)new DefaultLoginUser(), (Object)userVo);
        defaultLoginUser.setPassword("******");
        defaultLoginUser.setUserRealm(this.getName());
        return new SimpleAuthenticationInfo((Object)defaultLoginUser, (Object)userVo.getPassword(), this.getName());
    }
}

