/*
 * Decompiled with CFR 0.152.
 */
package com.sonsure.matrix.tile.shiro.realm;

import com.sonsure.commons.utils.UUIDUtils;
import com.sonsure.matrix.basic.context.LoginUser;
import com.sonsure.matrix.basic.context.PlatformContextHolder;
import com.sonsure.matrix.tile.essential.provider.SettingProvider;
import com.sonsure.matrix.tile.permission.service.UserRoleService;
import com.sonsure.matrix.tile.permission.vo.RoleVo;
import com.sonsure.matrix.tile.user.enums.UserStatus;
import com.sonsure.matrix.tile.user.enums.UserType;
import com.sonsure.matrix.tile.user.service.UserExtPropService;
import com.sonsure.matrix.tile.user.service.UserService;
import com.sonsure.matrix.tile.user.vo.AbstractLoginUser;
import com.sonsure.matrix.tile.user.vo.UserVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.CachingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthorizationRealmComposite
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(UserAuthorizationRealmComposite.class);
    private static final String REALM_CREATOR = "realm";
    private static final SimpleAuthorizationInfo AUTHORIZATION_INFO = new SimpleAuthorizationInfo();

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return AUTHORIZATION_INFO;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        List authorizingRealms = PlatformContextHolder.getServiceBeans(AuthorizingRealm.class);
        List<AuthorizingRealm> activeRealms = this.getActiveRealms(authorizingRealms);
        for (AuthorizingRealm activeRealm : activeRealms) {
            AuthenticationInfo authenticationInfo;
            try {
                authenticationInfo = activeRealm.getAuthenticationInfo(token);
            }
            catch (AuthenticationException e) {
                log.info("\u7528\u6237\u4f7f\u7528{}\u8ba4\u8bc1\u5931\u8d25:{}", (Object)activeRealm.getName(), (Object)token);
                continue;
            }
            if (authenticationInfo == null) continue;
            LoginUser loginUser = (LoginUser)authenticationInfo.getPrincipals().getPrimaryPrincipal();
            this.loginSuccessLocalHandler(loginUser, activeRealm);
            this.mergeLocalUser(loginUser);
            return authenticationInfo;
        }
        return null;
    }

    protected void assertCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) throws AuthenticationException {
    }

    private void mergeLocalUser(LoginUser loginUser) {
        if (!(loginUser instanceof AbstractLoginUser)) {
            return;
        }
        UserExtPropService userExtPropService = (UserExtPropService)PlatformContextHolder.getServiceBean(UserExtPropService.class);
        List allUserProps = userExtPropService.getAllUserProps(loginUser.getUserId());
        ((AbstractLoginUser)loginUser).addUserProps((Collection)allUserProps);
        Set<String> userRoleCodes = this.getUserRoleCodes(loginUser.getUserId());
        ((AbstractLoginUser)loginUser).setRoleCodes(userRoleCodes);
    }

    private Set<String> getUserRoleCodes(Long userId) {
        UserRoleService userRoleService = (UserRoleService)PlatformContextHolder.getServiceBean(UserRoleService.class);
        List userRoles = userRoleService.findUserRoles(userId);
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            return Collections.emptySet();
        }
        return userRoles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
    }

    private void loginSuccessLocalHandler(LoginUser loginUser, AuthorizingRealm activeRealm) {
        UserService userService = (UserService)PlatformContextHolder.getServiceBean(UserService.class);
        String ip = PlatformContextHolder.getWebKit().getRemoteIp();
        UserVo userVo = userService.getByRealmUsername(loginUser.getRealmUsername(), activeRealm.getName());
        if (userVo == null) {
            userVo = this.createLocalUser(loginUser, activeRealm, ip);
            Long userId = userService.insert(userVo);
            userVo.setUserId(userId);
        } else {
            UserVo updateUserVo = new UserVo();
            updateUserVo.setUserId(userVo.getUserId());
            updateUserVo.setLastLoginIp(ip);
            updateUserVo.setGmtLastLogin(LocalDateTime.now());
            userService.update(updateUserVo);
        }
        if (loginUser instanceof AbstractLoginUser) {
            AbstractLoginUser abstractLoginUser = (AbstractLoginUser)loginUser;
            abstractLoginUser.setUsername(loginUser.getRealmUsername());
            abstractLoginUser.setUserId(userVo.getUserId());
            abstractLoginUser.setUserRealm(activeRealm.getName());
            abstractLoginUser.setUserType(userVo.getUserType().getCode());
            abstractLoginUser.setStatus(userVo.getStatus().getCode());
            abstractLoginUser.setSex(userVo.getSex().getCode());
            abstractLoginUser.setRealName(userVo.getRealName());
            abstractLoginUser.setMobile(userVo.getMobile());
            abstractLoginUser.setAvatar(userVo.getAvatar());
        }
    }

    private UserVo createLocalUser(LoginUser loginUser, AuthorizingRealm activeRealm, String loginIp) {
        UserVo userVo = new UserVo();
        userVo.setUsername(UUIDUtils.getUUID16());
        userVo.setRealmUsername(loginUser.getRealmUsername());
        userVo.setPassword("********");
        userVo.setUserType(UserType.MEMBER);
        userVo.setUserRealm(activeRealm.getName());
        userVo.setStatus(UserStatus.NORMAL);
        userVo.setCreator(REALM_CREATOR);
        userVo.setSex(loginUser.getSex() == null ? UserVo.Sex.UNKNOWN : UserVo.Sex.of((String)loginUser.getSex()));
        userVo.setRealName(loginUser.getRealName());
        userVo.setEmail(loginUser.getEmail());
        userVo.setMobile(loginUser.getMobile());
        userVo.setAvatar(loginUser.getAvatar());
        userVo.setSignature(loginUser.getSignature());
        userVo.setLastLoginIp(loginIp);
        LocalDateTime now = LocalDateTime.now();
        userVo.setGmtCreate(now);
        userVo.setGmtLastLogin(now);
        return userVo;
    }

    private List<AuthorizingRealm> getActiveRealms(List<AuthorizingRealm> authorizingRealms) {
        SettingProvider settingProvider = (SettingProvider)PlatformContextHolder.getServiceBean(SettingProvider.class);
        List<String> activeAuthorizingRealms = settingProvider.getChildValues(new String[]{"permission_cfg", "active_authorizing_realms"});
        if (CollectionUtils.isEmpty((Collection)activeAuthorizingRealms)) {
            activeAuthorizingRealms = Collections.singletonList("local_authenticating_realm");
        }
        Map<String, AuthorizingRealm> realmMap = authorizingRealms.stream().collect(Collectors.toMap(CachingRealm::getName, a -> a));
        ArrayList<AuthorizingRealm> activeRealms = new ArrayList<AuthorizingRealm>();
        for (String activeAuthorizingRealm : activeAuthorizingRealms) {
            AuthorizingRealm authorizingRealm = realmMap.get(activeAuthorizingRealm);
            if (authorizingRealm == null) continue;
            activeRealms.add(authorizingRealm);
        }
        return activeRealms;
    }
}

