/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Projection;

public class Configuration {
    private final Projection projection;
    private final boolean interactive;
    private final boolean showZoomControls;

    private Configuration(Projection projection, boolean interactive, boolean showZoomControls) {
        this.projection = projection;
        this.interactive = interactive;
        this.showZoomControls = showZoomControls && interactive;
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public String toString() {
        return "Configuration{projection=" + this.projection + ", interactive=" + this.interactive + ", showZoomControls=" + this.showZoomControls + "}";
    }

    public Projection getProjection() {
        return this.projection;
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    public String toJson() {
        return "{\"projection\":\"" + this.projection.getOlName() + "\",\"interactive\":" + this.getInteractive() + ",\"showZoomControls\":" + this.showZoomControls() + "}";
    }

    public boolean showZoomControls() {
        return this.showZoomControls;
    }

    public static final class ConfigurationBuilder {
        private Projection projection = Projection.WEB_MERCATOR;
        private boolean interactive = true;
        private boolean showZoomControls = true;

        private ConfigurationBuilder() {
        }

        public ConfigurationBuilder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public ConfigurationBuilder interactive(boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public ConfigurationBuilder showZoomControls(boolean showZoomControls) {
            this.showZoomControls = showZoomControls;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.projection, this.interactive, this.showZoomControls);
        }
    }
}

