/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import java.util.Objects;

public final class Coordinate {
    private final Double latitude;
    private final Double longitude;

    public Coordinate(Double latitude, Double longitude) {
        this.latitude = Objects.requireNonNull(latitude);
        this.longitude = Objects.requireNonNull(longitude);
    }

    public final Double getLatitude() {
        return this.latitude;
    }

    public final Double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        int result = this.latitude.hashCode();
        result = 31 * result + this.longitude.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return this.latitude.equals(that.latitude) && this.longitude.equals(that.longitude);
    }

    public String toString() {
        return "[latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    public Coordinate normalize() {
        Double l = this.getLongitude();
        while (l < -180.0) {
            l = l + 360.0;
        }
        while (l > 180.0) {
            l = l - 360.0;
        }
        return new Coordinate(this.latitude, l);
    }
}

