/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.MapElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javafx.scene.paint.Color;

public class CoordinateLine
extends MapElement {
    public static final Color DEFAULT_COLOR = Color.web((String)"#32CD32", (double)0.7);
    public static final Color DEFAULT_FILL_COLOR = Color.web((String)"#ff8c00", (double)0.3);
    public static final int DEFAULT_WIDTH = 3;
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final String id;
    private final List<Coordinate> coordinates = new ArrayList<Coordinate>();
    private Color color;
    private Color fillColor;
    private int width;
    private Boolean closed = false;

    public CoordinateLine(List<? extends Coordinate> coordinates) {
        this.id = "coordinateline-" + nextId.getAndIncrement();
        Objects.requireNonNull(coordinates).stream().forEach(this.coordinates::add);
        this.color = DEFAULT_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
        this.width = 3;
    }

    public CoordinateLine(Coordinate ... coordinates) {
        this(Arrays.asList(Objects.requireNonNull(coordinates)));
    }

    public Color getColor() {
        return this.color;
    }

    public CoordinateLine setColor(Color color) {
        this.color = Objects.requireNonNull(color);
        return this;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public CoordinateLine setFillColor(Color color) {
        this.fillColor = Objects.requireNonNull(color);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public CoordinateLine setWidth(int width) {
        this.width = width;
        return this;
    }

    public Boolean isClosed() {
        return this.closed;
    }

    public CoordinateLine setClosed(Boolean closed) {
        this.closed = closed;
        return this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateLine that = (CoordinateLine)o;
        return this.id.equals(that.id);
    }

    @Override
    public String toString() {
        return "CoordinateLine{id='" + this.id + "', coordinates=" + this.coordinates + ", color=" + this.color + ", fillCclor=" + this.fillColor + ", width=" + this.width + ", closed=" + this.closed + "} " + super.toString();
    }

    @Override
    public CoordinateLine setVisible(boolean visible) {
        return (CoordinateLine)super.setVisible(visible);
    }

    public Stream<Coordinate> getCoordinateStream() {
        return this.coordinates.stream();
    }
}

