/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.MapElement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javafx.scene.paint.Color;

public class MapCircle
extends MapElement {
    public static final Color DEFAULT_COLOR = Color.web((String)"#32CD32", (double)0.7);
    public static final Color DEFAULT_FILL_COLOR = Color.web((String)"#ff8c00", (double)0.3);
    public static final int DEFAULT_WIDTH = 3;
    private static final AtomicLong nextId = new AtomicLong(1L);
    private final String id = "mapcircle-" + nextId.getAndIncrement();
    private Coordinate centerCoord;
    private double radiusInMeter;
    private Color color;
    private Color fillColor;
    private int width;

    public MapCircle(Coordinate centerCoord, double radiusInMeter) {
        this.centerCoord = centerCoord;
        this.radiusInMeter = radiusInMeter;
        this.color = DEFAULT_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
        this.width = 3;
    }

    public Coordinate getCenter() {
        return this.centerCoord;
    }

    public double getRadius() {
        return this.radiusInMeter;
    }

    public Color getColor() {
        return this.color;
    }

    public MapCircle setColor(Color color) {
        this.color = Objects.requireNonNull(color);
        return this;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public MapCircle setFillColor(Color color) {
        this.fillColor = Objects.requireNonNull(color);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public MapCircle setWidth(int width) {
        this.width = width;
        return this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapCircle that = (MapCircle)o;
        return this.id.equals(that.id);
    }

    @Override
    public String toString() {
        return "MapCircle{id='" + this.id + "', center=" + this.centerCoord + ", radius=" + this.radiusInMeter + ", color=" + this.color + ", fillCclor=" + this.fillColor + ", width=" + this.width + "} " + super.toString();
    }

    @Override
    public MapCircle setVisible(boolean visible) {
        return (MapCircle)super.setVisible(visible);
    }
}

