/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import com.sothawo.mapjfx.MapElement;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;

public abstract class MapCoordinateElement
extends MapElement {
    protected final SimpleObjectProperty<Coordinate> position = new SimpleObjectProperty();
    protected final int offsetX;
    protected final int offsetY;
    protected SimpleStringProperty cssClass = new SimpleStringProperty("");
    protected SimpleIntegerProperty rotation = new SimpleIntegerProperty(0);

    public MapCoordinateElement() {
        this(0, 0);
    }

    public MapCoordinateElement(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public String getCssClass() {
        return this.cssClass.get();
    }

    public MapCoordinateElement setCssClass(String cssClass) {
        this.cssClass.set(null == cssClass ? "" : cssClass);
        return this;
    }

    public SimpleStringProperty cssClassProperty() {
        return this.cssClass;
    }

    public Integer getRotation() {
        return this.rotation.get();
    }

    public MapCoordinateElement setRotation(Integer rotation) {
        this.rotation.set(rotation == null ? 0 : rotation);
        return this;
    }

    public SimpleIntegerProperty rotationProperty() {
        return this.rotation;
    }

    public abstract String getId();

    @Override
    public String toString() {
        return "MapCoordinateElement{position=" + this.position + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", cssClass=" + this.cssClass + ", rotation=" + this.rotation + ", visible=" + this.visible + "} " + super.toString();
    }

    public Coordinate getPosition() {
        return (Coordinate)this.position.get();
    }

    public SimpleObjectProperty<Coordinate> positionProperty() {
        return this.position;
    }

    public MapCoordinateElement setPosition(Coordinate position) {
        this.position.set((Object)position);
        return this;
    }
}

